/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <Strings.h>
#include <Setup.h>
#include <MainWindow.h>
#include <Logger.h>

#include <qapplication.h>
#include <qmessagebox.h>

#include <iostream>
#include <signal.h>

using namespace std;

void sighandler( int sig )
{
  QString message = QString("Signal %1 intercepted!").arg(sig);
  Logger::warning(message);
}

int main( int argc, char ** argv )
{
  QApplication app( argc, argv );

  //Parse command line
  int count=1;
  while ( count<app.argc() )
    {
      QString param(app.argv()[count++]);
      if ( param == "-trace" )
      {
      	  QString level(app.argv()[count++]);
      	  if (level.lower() == "debug" )
      	  {
      	  	Logger::setTraceLevel(Logger::DEBUG);
      	  }
      	  else if (level.lower() == "info" )
      	  {
      	  	Logger::setTraceLevel(Logger::INFO);
      	  }
      	  
      	  else if (level.lower() == "warning" )
      	  {
      	  	Logger::setTraceLevel(Logger::WARNING);
      	  }
      	  
      	  else if (level.lower() == "error" )
      	  {
      	  	Logger::setTraceLevel(Logger::ERROR);
      	  }
      	  else
          {
            Logger::warning("Invalid trace level - ignored!");
          }
      }
      else if ( param == "-debug" )
      {
          Logger::info("ViPEC: Entering debug mode.");
          Setup::instance()->setDebugMode( TRUE );
      }
      else
      {
          Logger::warning("Unknown command line option " + param + " - ignored!");
      }
    }

  const QString& languageFile = Setup::instance()->languageFile();
  QTranslator* translator = new QTranslator(0);
  if (!languageFile.isEmpty())
    {
      const QString& vipecHome = Setup::instance()->vipecHome();
      QString dirName = vipecHome + "/messages";
      Logger::debug("Looking for " + languageFile + " in directory" + dirName);
      QTranslator* translator = new QTranslator(0);
      translator->load( languageFile, dirName );
      app.installTranslator( translator );
    }
  app.installTranslator( translator );

  MainWindow* mw = MainWindow::instance();
  mw->setTranslator( translator );
  mw->resize(600,420);
  app.setMainWidget(mw);
  QString name = Strings::translate( Strings::MainWindowTitle );
  mw->setCaption( name );
  mw->show();
  app.connect( &app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()) );

#ifndef _WS_WIN_
  if ( !Setup::instance()->isDebugMode() )
    {
      struct sigaction act;
      act.sa_handler = sighandler;
      sigemptyset( &act.sa_mask );
      act.sa_flags = 0;
      sigaction( SIGINT, &act, 0 );
      sigaction( SIGQUIT, &act, 0 );
      sigaction( SIGKILL, &act, 0 );
    }
#endif

  try
    {
      return app.exec();
    }
  catch (...)
    {
      QMessageBox::warning( mw, Strings::LabelApplicationName,
                            "Unhandled exception! The application will close now." );
      return 1;
    }
}
