/* im_addgnoise
 *
 * Copyright 1990, N. Dessipris.
 *
 * File written on 2/12/1986
 * Author : N. Dessipris
 * Updated : 22/01/1991
 * 1/2/95 JC
 *	- junked!
 *	- now uses partial im_gaussnoise() and partial im_add() to do the
 *	  same job
 & 1/5/01 JC
 *	- oops, failed for not-1-band images
 *
 * 2008-01-28 tcv:
 *      - now works (was broken)
 *      - no limit on bands
 * 4/2/10
 * 	- no need to bandup here now, im_add() does that
 * 	- gtkdoc
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/**
 * im_addgnoise:
 * @in: input image
 * @out: output image
 * @sigma: standard deviation of noise
 *
 * Add gaussian noise with mean 0 and variance sigma to @in.
 * The noise is generated by averaging 12 random numbers,
 * see page 78, PIETGEN, 1989. 
 *
 * See also: im_gaussnoise().
 *
 * Returns: 0 on success, -1 on error
 */
int
im_addgnoise( IMAGE *in, IMAGE *out, double sigma )
{
	IMAGE *t;

	if( !(t = im_open_local( out, "im_addgnoise", "p" )) ||
		im_gaussnoise( t, in->Xsize, in->Ysize, 0, sigma ) ||
		im_add( in, t, out ) )
		return( -1 );

	return( 0 );
}
