/* @(#) Plot many points in a single call. Pass ink, array containing
 * @(#) 0/non-zero showing where to plot and Rect showing size of array and 
 * @(#) offset to get to centre of array. ix and iy are where to plot. Rect
 * @(#) can be any size, any position - we clip against the edges of the
 * @(#) image.
 * @(#) 
 * @(#) int
 * @(#) im_plotmask( IMAGE *im, int ix, int iy, PEL *ink, PEL *mask, Rect *r )
 * @(#) 
 *
 * Copyright: J. Cupitt
 * Written: 15/06/1992
 * 22/7/93 JC
 *	- im_incheck() added
 * 16/8/94 JC
 *	- im_incheck() changed to im_makerw()
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/rect.h>
#include <vips/util.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Plot lots of points! Pass ink, array of 0/255 showing where to plot, rect
 * showing size and offset for array. Used for fat lines and text.
 */
int
im_plotmask( IMAGE *im, int ix, int iy, PEL *ink, PEL *mask, Rect *r )
{	
	int es = im->Bbits >> 3;
	int ps = es * im->Bands;
	int ls = ps * im->Xsize;
	Rect area, image, clipped;
	int b;
	int x, y;
	int mx, my;
	PEL *to, *from;
	PEL *p, *q;

	if( im_rwcheck( im ) )
		return( -1 );

	/* Find area we plot.
	 */
	area = *r;
	area.left += ix;
	area.top += iy;
	image.left = 0;
	image.top = 0;
	image.width = im->Xsize;
	image.height = im->Ysize;
	im_rect_intersectrect( &area, &image, &clipped );

	/* Any points left to plot?
	 */
	if( im_rect_isempty( &clipped ) )
		return( 0 );

	/* Find area of mask we use.
	 */
	mx = IM_MAX( 0, clipped.left - area.left );
	my = IM_MAX( 0, clipped.top - area.top );

	/* Loop through image plotting where required.
	 */
	to = (PEL *) im->data + clipped.left * ps + clipped.top * ls;
	from = mask + mx + my * area.width;
	for( y = 0; y < clipped.height; y++ ) {
		p = from; q = to;

		for( x = 0; x < clipped.width; x++ )
			if( *p++ )
				for( b = 0; b < ps; b++ )
					*q++ = ink[b];
			else
				q += ps;
		
		from += area.width;
		to += ls;
	}

	return( 0 );
}

