/* debug.c: support for debugging
 *
 * 24/10/95 JC
 *	- first version
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>

#include <vips/vips.h>
#include <vips/util.h>
#include <vips/list.h>
#include <vips/debug.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Track all open images in this.
 */
List *im__open_images = NULL;

/* Print a one-line description of an image, with an index.
 */
static void *
print_one_line( IMAGE *im, int *n )
{
	printf( "%2d) %s, %s: %dx%d, %d bands, %s (0x%x)\n",
		*n, 
		im_dtype2char( im->dtype ), im->filename, 
		im->Xsize, im->Ysize, im->Bands,
		im_BandFmt2char( im->BandFmt ),
		(unsigned int) im );
	(*n)++;

	return( NULL );
}

/* Print one line for each open descriptor.
 */
void
im__print_all( void )
{
	int n = 0;

	(void) im_list_map( im__open_images, 
		(im_list_map_fn) print_one_line, &n, NULL );
}

/* Given an index, print everything we know about that descriptor.
 */
void
im__print_one( int n )
{
	IMAGE *im = im_list_index( im__open_images, n );

	if( !im ) {
		printf( "bad index: %s\n", im_errorstring() );
		return;
	}

	im_printdesc( im );
}
