/* @(#)  Function which copies IMAGE descriptor image2 to image1;
 * @(#) data, fd and filename are not copied
 * @(#) used to make programs simpler by copying most parameters
 * @(#) 
 * @(#) int 
 * @(#) im_cp_desc( image1, image2 )
 * @(#) IMAGE *image1, *image2;
 * @(#)
 * @(#) Returns 0 on success or -1 on fail.
 * @(#)
 *
 * Copyright: Nicos Dessipris
 * Written on: 09/02/1990
 * Modified on : 22/2/93 By Kirk Martinez: v6.3
 * 28/10/1992 J.Cupitt
 *	- now calls im_cp_Hist, and hence frees old history correctly
 * 10/5/93 J.Cupitt
 *	- checks return result from im_cp_Hist()
 * 22/11/00 JC
 *	- ANSIfied
 * 5/9/02 JC
 *	- copy Xoffset/Yoffset too
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int 
im_cp_desc( IMAGE *image1, IMAGE *image2 )
{
	if( im_image_sanity( image1 ) || im_image_sanity( image2 ) )
		return( -1 );

	image1->Xsize = image2->Xsize;
	image1->Ysize = image2->Ysize;
	image1->Bands = image2->Bands;
	image1->Bbits = image2->Bbits;
	image1->BandFmt = image2->BandFmt;
	image1->Type = image2->Type;
	image1->Coding = image2->Coding;
	image1->Xres = image2->Xres;
	image1->Yres = image2->Yres;
	image1->Xoffset = image2->Xoffset;
	image1->Yoffset = image2->Yoffset;

	if( im_cp_Hist( image1, image2 ) )
		return( -1 );

	return( 0 );
}
