/* @(#) create a VIPS file header based on an IMAGE and write it to the 
 * @(#) file descriptor pointed by image.  If the output file is not setup
 * @(#) an error code is returned. On return fd points after the file header,
 * @(#) ready for expecting raw image data.
 * @(#)
 * @(#) int 
 * @(#) im_crwrhd( image )
 * @(#) IMAGE *image;
 * @(#)
 * @(#)  Returns either 0 (success) or -1 (fail)
 *
 * Copyright: Nicos Dessipris
 * Written on: 16/01/1990
 * Modified on : 04/04/1990, 28/02/1991, 3/6/92 22/2/93 Kirk Martinez
 v6.3: Xres, Yres
 * 6/7/93 JC
 *	- ANSIfied
 *	- tidied up
 * 17/11/94 JC
 *	- new compression fields added
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#ifdef HAVE_IO_H
#include <io.h>
#endif /*HAVE_IO_H*/

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int 
im_crwrhd( IMAGE *image )
{
	VAS_HD hd;

#ifdef VERBOSEDEBUG
	fprintf( stderr, "im_crwrhd: read image descriptor" );
	im_printdesc( image );
#endif

	/* Create a VAS_HD from the image descriptor 
	 */
	im_inithd( &hd, 
		image->Bands, 
		image->Bbits, image->BandFmt,
		image->Xsize, image->Ysize, 
		image->Type, image->Coding,
		image->Xres, image->Yres,
		image->Length, image->Compression, image->Level,
		image->Xoffset, image->Yoffset );

#ifdef VERBOSEDEBUG
	fprintf( stderr, "im_crwrhd: created VAS_HD" );
	im_printhd( &hd );
#endif

	/* Write the created vasari header to image->fd 
	 */
	if( image->fd == 1 )            /* Check whether stdout is used */
		{
		im_errormsg("im_crwrhd: Unable to rewind stdout");
		return(-1);
		}

	if( lseek( image->fd, 0L, SEEK_SET ) < 0 ) {
		im_errormsg( "im_crwrhd: unable to lseek" );
		return( -1 );
	}

	if( im__write( image->fd, &hd, sizeof( VAS_HD ) ) )
		return( -1 );

	/* image->fd points to the end of the header expecting raw data.
	 */
	return( 0 );
}
