/* @(#) im_desc_hd: Copies vips file header to an IMAGE descriptor.
 * @(#) 
 * @(#) void 
 * @(#) im_desc_hd( image, header )
 * @(#) IMAGE *image;
 * @(#) VAS_HDR *header;
 * @(#)
 * @(#) Returns 0 on success and -1 on error
 *
 * Copyright: Nicos Dessipris
 * Written on: 13/02/1990
 * Modified on : 22/2/92 v6.3 Kirk Martinez
 * 17/11/94 JC
 *	- read compression fields too
 * 28/10/98 JC
 * 	- byteswap stuff added
 * 21/8/02 JC
 *	- oops, was truncating float
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>

#include <vips/vips.h>  

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Read short/int/float LSB and MSB first.
 */
static int
read_int_msb( unsigned char *from )
{
	return( from[0] << 24 | from[1] << 16 | from[2] << 8 | from[3] );
}

static int
read_int_lsb( unsigned char *from )
{
	return( from[3] << 24 | from[2] << 16 | from[1] << 8 | from[0] );
}

static int
read_short_msb( unsigned char *from )
{
	return( from[0] << 8 | from[1] );
}

static int
read_short_lsb( unsigned char *from )
{
	return( from[1] << 8 | from[0] );
}

static float
read_float_msb( unsigned char *from )
{
	int buf;
	float *f = (float *) &buf;

	buf = read_int_msb( from );
	return( *f );
}

static float
read_float_lsb( unsigned char *from )
{
	int buf;
	float *f = (float *) &buf;

	buf = read_int_lsb( from );
	return( *f );
}

int
im_desc_hd( IMAGE *image, VAS_HD *header )
{
	image->magic = (unsigned int) 
		read_int_msb( (unsigned char *) &header->Magic );
	if( image->magic != IM_MAGIC_INTEL &&
		image->magic != IM_MAGIC_SPARC ) {
		im_errormsg( "im_open: \"%s\" is not a VIPS image", 
			image->filename );
		return( -1 );
	}

	switch( image->magic ) {
	case IM_MAGIC_SPARC:
		/* All MSB first.
		 */
		image->Xsize = 
			read_int_msb( (unsigned char *) &header->Xsize );
		image->Ysize = 
			read_int_msb( (unsigned char *) &header->Ysize );
		image->Bands = 
			read_int_msb( (unsigned char *) &header->Bands );
		image->Bbits = 
			read_int_msb( (unsigned char *) &header->Bbits );
		image->BandFmt = 
			read_int_msb( (unsigned char *) &header->BandFmt );
		image->Coding = 
			read_int_msb( (unsigned char *) &header->Coding );
		image->Type = 
			read_int_msb( (unsigned char *) &header->Type );
		image->Xres = 
			read_float_msb( (unsigned char *) &header->Xres );
		image->Yres = 
			read_float_msb( (unsigned char *) &header->Yres );
		image->Length = 
			read_int_msb( (unsigned char *) &header->Length );
		image->Compression = 
			read_short_msb( (unsigned char *) &header->Compression );
		image->Level = 
			read_short_msb( (unsigned char *) &header->Level );
		image->Xoffset = 
			read_int_msb( (unsigned char *) &header->Xoffset );
		image->Yoffset = 
			read_int_msb( (unsigned char *) &header->Yoffset );

		break;

	case IM_MAGIC_INTEL:
		/* All LSB first.
		 */
		image->Xsize = 
			read_int_lsb( (unsigned char *) &header->Xsize );
		image->Ysize = 
			read_int_lsb( (unsigned char *) &header->Ysize );
		image->Bands = 
			read_int_lsb( (unsigned char *) &header->Bands );
		image->Bbits = 
			read_int_lsb( (unsigned char *) &header->Bbits );
		image->BandFmt = 
			read_int_lsb( (unsigned char *) &header->BandFmt );
		image->Coding = 
			read_int_lsb( (unsigned char *) &header->Coding );
		image->Type = 
			read_int_lsb( (unsigned char *) &header->Type );
		image->Xres = 
			read_float_lsb( (unsigned char *) &header->Xres );
		image->Yres = 
			read_float_lsb( (unsigned char *) &header->Yres );
		image->Length = 
			read_int_lsb( (unsigned char *) &header->Length );
		image->Compression = 
			read_short_lsb( (unsigned char *) &header->Compression );
		image->Level = 
			read_short_lsb( (unsigned char *) &header->Level );
		image->Xoffset = 
			read_int_lsb( (unsigned char *) &header->Xoffset );
		image->Yoffset = 
			read_int_lsb( (unsigned char *) &header->Yoffset );

		break;

	default:
		im_errormsg( "im_desc_hd: unknown image type" );
		return( -1 );
	}

#ifdef VERBOSEDEBUG
	fprintf(stderr, "Debug: im_desc_hd: Printing the set image descriptor");
	im_printdesc(image);
#endif

	return( 0 );
}
