/* @(#) initialise file header of a vips format picture
 * @(#)  Static strings must be modified if header files are changed
 * @(#) The function init_hd() initialises the header with the values passed
 * @(#) as parameters. It also initialises the remaining sections
 * @(#) of the header (magic, pad[SPARE]).
 * @(#) HANDLESHEADER
 * 
 * @(#) void im_inithd(pheader, bnd, bndbits, bndfmt, xsize, ysize,
 * @(#)                 imtype, codfmt, xres, yres)
 * @(#) VAS_HD *pheader;
 * @(#) int bnd, bndbits, bndfmt, xsize, ysize, imtype, codfmt;
 * @(#) float xres, yres;
 * @(#) RETURNS: nothing
 * Copyright: Nicos Dessipris
 * Written on: 24/01/1990
 * Modified on : 22/2/93 Kirk Martinez
 *	- now pads with 0
 * 6/7/93 JC
 *	- ANSIfied
 * 21/7/93 JC
 *	- xres/yres have to be double if ANSI C + no prototype!
 * 17/11/94 JC
 *	- added new compression fields
 * 29/10/98 JC
 * 	- now writes native header
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <sys/types.h>

#include <vips/vips.h>
#include <vips/proto.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Write an unsigned int MSB first. Used to write maginc number.
 */
static void
write_int_msb( unsigned char *to, int from )
{
	to[0] = (from >> 24) & 0xff;
	to[1] = (from >> 16) & 0xff;
	to[2] = (from >> 8) & 0xff;
	to[3] = from & 0xff;
}

void 
im_inithd( VAS_HD *hd, int bnd, int bndbits, int bndfmt, 
	int xsize, int ysize, 
	int imtype, int codfmt, double xres, double yres,
	int Length, int Compression, int Level,
	int Xoffset, int Yoffset )
{	
	int i;

	if( im_amiMSBfirst() )
		write_int_msb( (unsigned char *) &hd->Magic, IM_MAGIC_SPARC );
	else
		write_int_msb( (unsigned char *) &hd->Magic, IM_MAGIC_INTEL );

	hd->Xsize = xsize;
	hd->Ysize = ysize;
	hd->Bands = bnd;
	hd->Bbits = bndbits;
	hd->BandFmt = bndfmt;
	hd->Type = imtype;
	hd->Coding = codfmt;
	hd->Xres = xres;
	hd->Yres = yres;
	hd->Length = Length;
	hd->Compression = Compression;
	hd->Level = Level;
	hd->Xoffset = Xoffset;
	hd->Yoffset = Yoffset;

	/* Pad spares with zeros.
	 */
	for( i = 0; i < IM_SPARE; i++ )
		hd->Pad[i] = 0;
}
