/* @(#) Invert a DOUBLEMASK. Convert it to a matrix in numerical recipies 
 * @(#) in C style and call im_invmat. Pass in the filename we should set 
 * @(#) for the output.
 * @(#)
 * @(#) DOUBLEMASK *
 * @(#) im_matinv( mask, name )
 * @(#) DOUBLEMASK *mask;
 * @(#) char *name;
 * @(#)  
 * @(#) NULL for error, otherwise returns new mask. Scale and offset are
 * @(#) ignored.
 *
 * Author: John Cupitt
 * Written on: 19 August 1992
 * Modified on : 
 * 20/11/98 JC
 *	- ansified
 * 17/5/01 JC
 *	- failed to free correctly on singular matrix
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

DOUBLEMASK *
im_matinv( DOUBLEMASK *in, const char *name )
{
	DOUBLEMASK *out;
	double **mat;

	/* Is our input sensible?
	 */
	if( in->xsize != in->ysize || in->xsize <= 0 ) {
		im_errormsg( "im_matinv: unsuitable mask for inversion" );
		return( NULL );
	}

	/* Make output mask.
	 */
	if( !(out = im_create_dmask( name, in->xsize, in->ysize )) ) {
		im_errormsg( "im_matinv: unable to allocate output mask" );
		return( NULL );
	}

	/* Make suitable matrix, copy, invert and copy to output.
	 */
	if( !(mat = im_dmat_alloc( 0, in->xsize-1, 0, in->ysize-1 )) ) {
		im_free_dmask( out );
		im_errormsg( "im_matinv: unable to allocate matrix" );
		return( NULL );
	}
	im_copy_dmask_matrix( in, mat );
	if( im_invmat( mat, in->xsize ) ) {
		im_free_dmat( mat, 0, in->xsize-1, 0, in->ysize-1 );
		im_free_dmask( out );
		im_errormsg( "im_matinv: unable to invert" );
		return( NULL );
	}
	im_copy_matrix_dmask( mat, out );

	/* Free resources.
	 */
	im_free_dmat( mat, 0, in->xsize-1, 0, in->ysize-1 );

	return( out );
}
