/* @(#) Command; reads the header of a Vasari picture file.
 * @(#) Usage: header vasari_file
 * @(#) 
 *
 * Copyright: Birkbeck College, History of Art Dept, London, VASARI project.
 *
 * Author: Nicos Dessipris
 * Written on: 17/01/1990
 * Modified on : 17/04/1990, 2/6/93 K.Martinez
 * 16/6/93 JC
 *	- now calls im_mmapin instead of bizzare bogosity
 * 1/6/95 JC
 *	- extra field argument for testing particular bits of the header
 * 29/10/98 JC
 *	- now uses im_open()
 * 24/5/01 JC
 *	- uses im_tiff2vips_header() etc., for speed
 * 7/5/03 JC
 *	- uses im_open_header()
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <stdio.h>
#include <string.h>

#include <vips/vips.h>

int
main( int argc, char *argv[] )
{
	IMAGE *im;

	if( argc > 3 || argc < 2 ) 
		error_exit( "usage: %s vips_file [field]", argv[0] );

	if( !(im = im_open_header( argv[1] )) )
		error_exit( "header: unable to open %s", argv[1] );

	/* Print header, or parts of header.
	 */
	if( argc == 2 )
		im_printdesc( im );
	if( argc == 3 ) {
		if( strcmp( argv[2], "Xsize" ) == 0 )
			printf( "%d", im->Xsize );
		else if( strcmp( argv[2], "Ysize" ) == 0 )
			printf( "%d", im->Ysize );
		else if( strcmp( argv[2], "Bands" ) == 0 )
			printf( "%d", im->Bands );
		else if( strcmp( argv[2], "Bbits" ) == 0 )
			printf( "%d", im->Bbits );
		else if( strcmp( argv[2], "BandFmt" ) == 0 )
			printf( "%s", im_BandFmt2char( im->BandFmt ) );
		else if( strcmp( argv[2], "Type" ) == 0 )
			printf( "%s", im_Type2char( im->Type ) );
		else if( strcmp( argv[2], "Coding" ) == 0 )
			printf( "%s", im_Coding2char( im->Coding ) );
		else if( strcmp( argv[2], "Xres" ) == 0 )
			printf( "%g", im->Xres );
		else if( strcmp( argv[2], "Yres" ) == 0 )
			printf( "%g", im->Yres );
		else if( strcmp( argv[2], "Length" ) == 0 )
			printf( "%d", im->Length );
		else if( strcmp( argv[2], "Compression" ) == 0 )
			printf( "%d", im->Compression );
		else if( strcmp( argv[2], "Level" ) == 0 )
			printf( "%d", im->Level );
		else if( strcmp( argv[2], "Xoffset" ) == 0 )
			printf( "%d", im->Xoffset );
		else if( strcmp( argv[2], "Yoffset" ) == 0 )
			printf( "%d", im->Yoffset );
		else 
			error_exit( "unknown header field: %s", argv[2] );
	}

	if( im_close( im ) )
		error_exit( "header: unable to close %s", im->filename );

	return( 0 );
}
