/** @file
 *
 * VBox frontends: Qt GUI ("VirtualBox"):
 * VirtualBox Qt extensions: QIHotKeyEdit class declaration
 */

/*
 * Copyright (C) 2006-2007 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef ___QIHotKeyEdit_h___
#define ___QIHotKeyEdit_h___

#include <QLabel>

#ifdef Q_WS_X11
# include <QMap>
#endif

#ifdef Q_WS_PM
/* Extra virtual keys returned by QIHotKeyEdit::virtualKey() */
# define VK_LSHIFT   VK_USERFIRST + 0
# define VK_LCTRL    VK_USERFIRST + 1
# define VK_LWIN     VK_USERFIRST + 2
# define VK_RWIN     VK_USERFIRST + 3
# define VK_WINMENU  VK_USERFIRST + 4
# define VK_FORWARD  VK_USERFIRST + 5
# define VK_BACKWARD VK_USERFIRST + 6
#endif

class QIHotKeyEdit : public QLabel
{
    Q_OBJECT

public:

    QIHotKeyEdit (QWidget *aParent);
    virtual ~QIHotKeyEdit();

    void setKey (int aKeyVal);
    int key() const { return mKeyVal; }

    QString symbolicName() const { return mSymbName; }

    QSize sizeHint() const;
    QSize minimumSizeHint() const;

#ifdef Q_WS_PM
    static int virtualKey (QMSG *aMsg);
#endif

#if defined (Q_WS_PM) || defined (Q_WS_X11)
    static void retranslateUi();
#endif
    static QString keyName (int aKeyVal);
    static bool isValidKey (int aKeyVal);

public slots:

    void clear();

protected:

#if defined (Q_WS_WIN32)
    bool winEvent (MSG *aMsg, long *aResult);
#elif defined (Q_WS_PM)
    bool pmEvent (QMSG *aMsg);
#elif defined (Q_WS_X11)
    bool x11Event (XEvent *event);
#elif defined (Q_WS_MAC)
    static bool darwinEventHandlerProc (const void *pvCocoaEvent, const void *pvCarbonEvent, void *pvUser);
    bool darwinKeyboardEvent (const void *pvCocoaEvent, EventRef inEvent);
#endif

    void focusInEvent (QFocusEvent *);
    void focusOutEvent (QFocusEvent *);

    void paintEvent (QPaintEvent *);

private:

    void updateText();

    int mKeyVal;
    QString mSymbName;

#if defined (Q_WS_PM)
    static QMap <int, QString> sKeyNames;
#elif defined (Q_WS_X11)
    static QMap <QString, QString> sKeyNames;
#endif

#ifdef Q_WS_MAC
    /** The current modifier key mask. Used to figure out which modifier
     *  key was pressed when we get a kEventRawKeyModifiersChanged event. */
    uint32_t mDarwinKeyModifiers;
#endif

    static const char *kNoneSymbName;
};

#endif // !___QIHotKeyEdit_h___

