/*
 * PropertyPanel.java
 *
 * Created on November 18, 2002, 3:51 PM
 */

package org.netbeans.test.editor.app.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.test.editor.app.Main;
import org.netbeans.test.editor.app.core.properties.BooleanProperty;
import org.netbeans.test.editor.app.core.properties.IntegerProperty;
import org.netbeans.test.editor.app.core.properties.MultiLineStringProperty;
import org.netbeans.test.editor.app.core.properties.Property;
import org.netbeans.test.editor.app.core.properties.StringProperty;

/**
 *
 * @author  eh103527
 */
public class PropertyPanel extends javax.swing.JPanel {
    
    // Variables declaration - do not modify
    protected javax.swing.JButton button;
    // End of variables declaration
    protected javax.swing.JComponent editField;
    protected javax.swing.JPanel editorPanel;
    protected javax.swing.JButton editorButton;
    
    protected String propertyName;
    protected Property property;
    protected boolean buttonState=true;
    protected PropertiesDialog dialog;
    
    protected String oldText;
    protected boolean readOnly=false;
    private boolean change=false;
    
    
    protected PropertyPanel() {
    }
    
    /** Creates new form PropertyPanel */
    public PropertyPanel(Object prop,String name) {
        propertyName=name;
        property=(Property)prop;
        initComponents();
        generateEdit();
        button.setText(property.getProperty());
        oldText=button.getText();
    }
    
    public PropertyPanel(Object prop,String name,boolean read) {
        this(prop,name);
        readOnly=read;
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    protected void initComponents() {
        button = new javax.swing.JButton();
        setLayout(new java.awt.CardLayout());
        button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonPressed(evt);
            }
        });
        button.setHorizontalAlignment(JButton.LEFT);
        add(button, "button");
    }
    
    protected void buttonPressed(java.awt.event.ActionEvent evt) {
        // Add your handling code here:
        if (!readOnly) {
            buttonState=false;
            oldText=button.getText();
            if (property instanceof StringProperty) {
                ((JTextField)editField).setText(property.getProperty());
            } else if (property instanceof BooleanProperty) {
                ((JComboBox)editField).setSelectedItem(property.getProperty());
            } else if (property instanceof IntegerProperty) {
                ((JTextField)editField).setText(property.getProperty());
            } else if (property instanceof MultiLineStringProperty) {
                ((JTextArea)editField).setText(property.getProperty());
            }
            if (evt != null) {
                //            evt.setSource(this);
                evt=new ActionEvent(this,evt.getID(),evt.getActionCommand(),evt.getModifiers());
                dialog.buttonPressed(evt);
            }
            ((CardLayout)(getLayout())).show(this,"edit");
            change=false;
        }
    }
    
    protected void focusLost(java.awt.event.FocusEvent evt) {
        // Add your handling code here:
        buttonState=true;
        if (property instanceof StringProperty) {
            property.setProperty(((JTextField)editField).getText());
        } else if (property instanceof BooleanProperty) {
            property.setProperty((String)(((JComboBox)editField).getSelectedItem()));
        } else if (property instanceof IntegerProperty) {
            property.setProperty(((JTextField)editField).getText());
        } else if (property instanceof MultiLineStringProperty) {
            property.setProperty(((JTextArea)editField).getText());
        }
        button.setText(property.getProperty());
        ((CardLayout)(getLayout())).show(this,"button");
        if (button.getText().compareTo(oldText) != 0) {
            oldText=button.getText();
            dialog.propertyChanged(propertyName,property);
        }
    }
    
    protected void keyPressed(java.awt.event.KeyEvent evt) {
        // Add your handling code here:
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            focusLost(null);
        }
    }
    
    public void changeState(ActionEvent ev) {
        if (buttonState) {
            buttonPressed(ev);
        } else {
            focusLost(null);
        }
    }
    
    public void setState(boolean state) {
        if (state != buttonState) {
            changeState(null);
        }
    }
    
    protected void generateEdit() {
        editorPanel = new JPanel(new BorderLayout());
        
        if (property instanceof StringProperty) {
            editField=new JTextField(property.getProperty());
        } else if (property instanceof BooleanProperty) {
            editField=new JComboBox(((BooleanProperty)property).getValues());
            ((JComboBox)(editField)).setSelectedItem(((BooleanProperty)property).getProperty());
        } else if (property instanceof IntegerProperty) {
            editField=new JTextField(property.getProperty());
        } else if (property instanceof MultiLineStringProperty) {
            editField=new JTextArea(property.getProperty());
            editorButton = new JButton("...");
            editorButton.addActionListener(new ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    propertyEditorInvoked();
                }
            });
            editorPanel.add(editorButton, BorderLayout.EAST);
        }
        editField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                PropertyPanel.this.focusLost(evt);
            }
        });
        editField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                PropertyPanel.this.keyPressed(evt);
            }
        });
        editorPanel.add(editField, BorderLayout.CENTER);
        add(editorPanel, "edit");
    }
    
    private void propertyEditorInvoked() {
        StringPropertyEditor dlg = new StringPropertyEditor(Main.frame, propertyName, ((MultiLineStringProperty)property).getProperty());
        dlg.show();
        if (dlg.getState()) {
            property.setProperty(dlg.getValue());
            ((JTextArea)editField).setText(dlg.getValue());
            button.setText(dlg.getValue());
            if (button.getText().compareTo(oldText) != 0) {
                oldText=button.getText();
                dialog.propertyChanged(propertyName,property);
            }
        }
    }
    
    /** Setter for property dialog.
     * @param dialog New value of property dialog.
     *
     */
    public void setDialog(PropertiesDialog dialog) {
        this.dialog = dialog;
    }
    
    /** Getter for property property.
     * @return Value of property property.
     *
     */
    public java.lang.Object getProperty() {
        return property;
    }
    
    /** Setter for property property.
     * @param property New value of property property.
     *
     */
    public void setProperty(java.lang.Object property) {
        this.property = (Property)property;
        button.setText(this.property.getProperty());
        oldText=button.getText();
        repaint();
    }
    
}
