/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file Render_opengl.cpp
 */
 
#include "Render_area.hpp"
#include "Render_opengl.hpp"
#include "../interface/interface_console.hpp"

using namespace std;


#define message *Message::get_instance() << "(" << __FILE__ << " l." << __LINE__ << "): "


/***********************************
 *
 *
 *
 * Constructor and destructor.
 *
 *
 *
 **********************************/

Render_opengl::Render_opengl(Render_opengl* render, Interface_console* core, QWidget *parent)
    : Render_area(render, core, parent){
   

     setAutoFillBackground(false);
}


Render_opengl::~Render_opengl(){

}

/***********************************
 *
 *
 *
 * Default QGLWidget functions.
 *
 *
 *
 **********************************/

void  Render_opengl::initializeGL() {
    glClearColor(0.5f, 0.5f, 0.55f, 1.0f);

    glEnable(GL_DEPTH_TEST);

    glClearStencil(0);

    _wait_list = draw_wait();
    _list_ruler = draw_ruler();
}

void  Render_opengl::resizeGL(int width, int height) {
    glViewport(0, 0, width, height);
    
    /* update informations about widget size */
    _screen_width = width;
    _screen_height = height;
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();


        
    if(DRAWING_STATE_WAITING == _state){// A wait is drawn
        glOrtho(-50, 50, -50, 50, 0, 1000);
    }else if (DRAWING_STATE_DRAWING == _state){// A trace is drawn 
        glOrtho(0, _render_width, 0, _render_height, 0, -1000);
    }else{
        message << "Undefined value for the drawing state attribute - Render area" << Message::ende;
    }
      

    glMatrixMode(GL_MODELVIEW);

}


void  Render_opengl::paintGL(){
    resizeGL(Render_opengl::QGLWidget::width(), Render_opengl::QGLWidget::height());
    Render_opengl::QGLWidget::setFocus(Qt::ActiveWindowFocusReason);/* give the focus to the render area for mouse and keyboard events */
    glClearDepth(1.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glLoadIdentity();

   
    if(DRAWING_STATE_WAITING == _state){/* A wait is drawn */
        
        /* turn around y axis */
        _wait_angle+=0.1f;
        if (_wait_angle>=360) _wait_angle=0.0f;
      
        glPushMatrix();
      
        glScalef(15, 15, 0);
      
        glRotatef(-_wait_angle,0, 1, 0);
        glRotatef(_wait_angle_y, 1, 0, 0);
        
        glCallList(_wait_list);

        glPopMatrix();
	
    
    }else if (DRAWING_STATE_DRAWING == _state){/* A trace is drawn */
        
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();

        glPushMatrix();
	{
	    static float a = 0;
	    a ++;
            
	    glTranslated(0.0, _render_height, 100.0);
	    glRotated(180.0, 1.0, 0.0, 0.0);
	    
            /* Translate containers and entities of the ruler height */
	    glTranslated(0.0, _ruler_height, 0.0);
	    
	    
            display_container(0, 0);

            display_state(0, 0, 0, 0, 0, 0);

            if (false == Info::Render::_no_arrows)/* display arrows */
                display_arrow(0, 0, 0, 0, 0, 0);
            
            if (false == Info::Render::_no_events)/* display events */
                display_event(0, 0, 0, 0);

            display_counter(0, 0, 0, 0);

	
            /* Untranslate ruler */
	    glTranslated(0.0, -_ruler_height, 0.0);

            glEnable(GL_BLEND);
            glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
            call_ruler();
            glDisable(GL_BLEND);
                        
        }
        glPopMatrix();

        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();

        glPushMatrix();
        {
            //   glTranslated(0.0, _container_y_max- 3*_ruler_height, 100.0);/* not accurate */
            glTranslated(0.0,  0.0, 100.0);/* not accurate */
           
            if (_mouse_pressed){
               
               
                glTranslated(0.0, 0.0, _z_container_under);
               
                Element_pos old_x, old_y, new_x, new_y;
               
                old_x = _mouse_x*(_render_width/_screen_width);
                old_y =  _render_height - _mouse_y*(_render_height/_screen_height);
                new_x = _new_mouse_x*(_render_width/_screen_width);
                new_y =  _render_height - _new_mouse_y*(_render_height/_screen_height);

#ifdef DEBUG_MODE_RENDER_OPENGL
               
                cerr << __FILE__ << " l." << __LINE__ << ":" << endl;  
                cerr << "Selection rectangle position: (" << old_x << ", " << old_y << ") - (" << new_x << ", " << new_y << ")" << endl;  
#endif
               
                glEnable(GL_BLEND);
                glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
               
                /* Square for selection */
                glBegin(GL_QUADS);
                {
                    glColor4d(0.9, 1.0, 0.9, _selection_rectangle_alpha);glVertex2d(old_x, old_y);
                    glColor4d(0.9, 0.9, 0.9, _selection_rectangle_alpha);glVertex2d(old_x, new_y);
                    glColor4d(0.9, 0.9, 0.9, _selection_rectangle_alpha);glVertex2d(new_x, new_y);
                    glColor4d(0.9, 0.9, 0.9, _selection_rectangle_alpha);glVertex2d(new_x, old_y);
                }
                glEnd();
              
                glDisable(GL_BLEND);
                               
            }/* end  if (true==_mouse_pressed) */
        }
        glPopMatrix();



    }else{
        message << "Undefined value for the drawing state attribute - Render area" << Message::ende;
    }
    
 
    glFlush();


    /* Check the errors */
    GLenum glerror;
    glerror = glGetError();
    if(glerror != GL_NO_ERROR)
        message << "Render area : the following OpengGL error occured: " << (char *)gluErrorString(glerror) << Message::endw;
}
