# How to Contribute

We'd love to accept your patches and contributions to this project.

Notably, we're working to make this project contributor-friendly. Please follow the
progress and comment [here](https://github.com/tensorflow/model-optimization/issues/131).

## One-time Setup

### Contributor License Agreement

Contributions to this project must be accompanied by a Contributor License
Agreement. You (or your employer) retain the copyright to your contribution;
this simply gives us permission to use and redistribute your contributions as
part of the project. Head over to <https://cla.developers.google.com/> to see
your current agreements on file or to sign a new one.

You generally only need to submit a CLA once, so if you've already submitted one
(even if it was for a different project), you probably don't need to do it
again.

## TensorFlow Model Optimization Specific

### Style
Please refer to [TensorFlow's style guide](https://www.tensorflow.org/community/contribute/code_style). Don't forget to run pylint.

### Contributing Whole Techniques

See these [guidelines](CONTRIBUTING_TECHNIQUE.md).

### Other Contributions

There are two categories of PRs that are welcome:

1. All documentation fixes.

2. PRs for issues labeled with ["contributions welcome"](https://github.com/tensorflow/model-optimization/issues?q=is%3Aissue+is%3Aopen+label%3A%22contributions+welcome%22).
TFMOT considers these issues critical enough to fix (e.g. significant impact on user experience) and will provide basic guidance to volunteers. The list
is intentionally kept small. Prior to starting, it'd be a good idea to see if the issue is still important.

For other types of PRs, file a Github issue first, using an available template. If it makes sense
, we'll attach the "contributions welcome" label and assign you the issue.

Issues with a ["good first issue" label](https://github.com/tensorflow/model-optimization/issues?utf8=%E2%9C%93&q=is%3Aopen+label%3A%22contributions+welcome%22+label%3A%22good+first+issue%22+)
are good for new contributors.

These guidelines seek to prioritize efforts that would benefit the community the most.
Feedback is welcome.


New features and bug fixes for documented features should come with a
modification to the [release notes](RELEASE.md).

## Code reviews

All submissions, including submissions by project members, require review. We
use GitHub pull requests for this purpose. Consult
[GitHub Help](https://help.github.com/articles/about-pull-requests/) for more
information on using pull requests.

## Community Guidelines

This project follows [Google's Open Source Community
Guidelines](https://opensource.google.com/conduct/). Please also
look at the [TensorFlow contributor
guide](https://www.tensorflow.org/community/contribute), in particular for the
community values.
