// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(adc)                       \
  M(adcs)                      \
  M(add)                       \
  M(adds)                      \
  M(and_)                      \
  M(ands)                      \
  M(bic)                       \
  M(bics)                      \
  M(eor)                       \
  M(eors)                      \
  M(orn)                       \
  M(orns)                      \
  M(orr)                       \
  M(orrs)                      \
  M(rsb)                       \
  M(rsbs)                      \
  M(sbc)                       \
  M(sbcs)                      \
  M(sub)                       \
  M(subs)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Register rm;
  ShiftType shift;
  uint32_t amount;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{al, r12, r4, r7, LSL, 7},
                            false,
                            al,
                            "al r12 r4 r7 LSL 7",
                            "al_r12_r4_r7_LSL_7"},
                           {{al, r7, r8, r10, ROR, 21},
                            false,
                            al,
                            "al r7 r8 r10 ROR 21",
                            "al_r7_r8_r10_ROR_21"},
                           {{al, r5, r5, r3, ROR, 12},
                            false,
                            al,
                            "al r5 r5 r3 ROR 12",
                            "al_r5_r5_r3_ROR_12"},
                           {{al, r14, r13, r10, LSL, 22},
                            false,
                            al,
                            "al r14 r13 r10 LSL 22",
                            "al_r14_r13_r10_LSL_22"},
                           {{al, r9, r10, r11, ROR, 2},
                            false,
                            al,
                            "al r9 r10 r11 ROR 2",
                            "al_r9_r10_r11_ROR_2"},
                           {{al, r14, r11, r5, LSL, 15},
                            false,
                            al,
                            "al r14 r11 r5 LSL 15",
                            "al_r14_r11_r5_LSL_15"},
                           {{al, r2, r2, r7, LSL, 28},
                            false,
                            al,
                            "al r2 r2 r7 LSL 28",
                            "al_r2_r2_r7_LSL_28"},
                           {{al, r2, r11, r1, ROR, 9},
                            false,
                            al,
                            "al r2 r11 r1 ROR 9",
                            "al_r2_r11_r1_ROR_9"},
                           {{al, r11, r2, r8, LSL, 4},
                            false,
                            al,
                            "al r11 r2 r8 LSL 4",
                            "al_r11_r2_r8_LSL_4"},
                           {{al, r6, r13, r3, ROR, 1},
                            false,
                            al,
                            "al r6 r13 r3 ROR 1",
                            "al_r6_r13_r3_ROR_1"},
                           {{al, r13, r2, r7, LSL, 11},
                            false,
                            al,
                            "al r13 r2 r7 LSL 11",
                            "al_r13_r2_r7_LSL_11"},
                           {{al, r9, r9, r1, LSL, 29},
                            false,
                            al,
                            "al r9 r9 r1 LSL 29",
                            "al_r9_r9_r1_LSL_29"},
                           {{al, r2, r12, r1, LSL, 15},
                            false,
                            al,
                            "al r2 r12 r1 LSL 15",
                            "al_r2_r12_r1_LSL_15"},
                           {{al, r0, r2, r11, LSL, 10},
                            false,
                            al,
                            "al r0 r2 r11 LSL 10",
                            "al_r0_r2_r11_LSL_10"},
                           {{al, r11, r12, r8, LSL, 13},
                            false,
                            al,
                            "al r11 r12 r8 LSL 13",
                            "al_r11_r12_r8_LSL_13"},
                           {{al, r3, r1, r6, ROR, 3},
                            false,
                            al,
                            "al r3 r1 r6 ROR 3",
                            "al_r3_r1_r6_ROR_3"},
                           {{al, r5, r9, r11, LSL, 16},
                            false,
                            al,
                            "al r5 r9 r11 LSL 16",
                            "al_r5_r9_r11_LSL_16"},
                           {{al, r2, r0, r6, ROR, 3},
                            false,
                            al,
                            "al r2 r0 r6 ROR 3",
                            "al_r2_r0_r6_ROR_3"},
                           {{al, r7, r10, r10, ROR, 19},
                            false,
                            al,
                            "al r7 r10 r10 ROR 19",
                            "al_r7_r10_r10_ROR_19"},
                           {{al, r14, r12, r11, LSL, 27},
                            false,
                            al,
                            "al r14 r12 r11 LSL 27",
                            "al_r14_r12_r11_LSL_27"},
                           {{al, r2, r13, r1, LSL, 3},
                            false,
                            al,
                            "al r2 r13 r1 LSL 3",
                            "al_r2_r13_r1_LSL_3"},
                           {{al, r5, r3, r2, LSL, 11},
                            false,
                            al,
                            "al r5 r3 r2 LSL 11",
                            "al_r5_r3_r2_LSL_11"},
                           {{al, r10, r3, r6, ROR, 1},
                            false,
                            al,
                            "al r10 r3 r6 ROR 1",
                            "al_r10_r3_r6_ROR_1"},
                           {{al, r6, r14, r2, ROR, 13},
                            false,
                            al,
                            "al r6 r14 r2 ROR 13",
                            "al_r6_r14_r2_ROR_13"},
                           {{al, r9, r8, r6, ROR, 13},
                            false,
                            al,
                            "al r9 r8 r6 ROR 13",
                            "al_r9_r8_r6_ROR_13"},
                           {{al, r12, r5, r8, LSL, 22},
                            false,
                            al,
                            "al r12 r5 r8 LSL 22",
                            "al_r12_r5_r8_LSL_22"},
                           {{al, r11, r8, r11, LSL, 3},
                            false,
                            al,
                            "al r11 r8 r11 LSL 3",
                            "al_r11_r8_r11_LSL_3"},
                           {{al, r0, r9, r4, LSL, 24},
                            false,
                            al,
                            "al r0 r9 r4 LSL 24",
                            "al_r0_r9_r4_LSL_24"},
                           {{al, r2, r2, r7, ROR, 30},
                            false,
                            al,
                            "al r2 r2 r7 ROR 30",
                            "al_r2_r2_r7_ROR_30"},
                           {{al, r9, r3, r10, LSL, 27},
                            false,
                            al,
                            "al r9 r3 r10 LSL 27",
                            "al_r9_r3_r10_LSL_27"},
                           {{al, r10, r4, r11, LSL, 23},
                            false,
                            al,
                            "al r10 r4 r11 LSL 23",
                            "al_r10_r4_r11_LSL_23"},
                           {{al, r12, r5, r11, ROR, 8},
                            false,
                            al,
                            "al r12 r5 r11 ROR 8",
                            "al_r12_r5_r11_ROR_8"},
                           {{al, r6, r6, r6, ROR, 4},
                            false,
                            al,
                            "al r6 r6 r6 ROR 4",
                            "al_r6_r6_r6_ROR_4"},
                           {{al, r5, r5, r10, ROR, 29},
                            false,
                            al,
                            "al r5 r5 r10 ROR 29",
                            "al_r5_r5_r10_ROR_29"},
                           {{al, r12, r12, r1, LSL, 8},
                            false,
                            al,
                            "al r12 r12 r1 LSL 8",
                            "al_r12_r12_r1_LSL_8"},
                           {{al, r5, r3, r1, LSL, 4},
                            false,
                            al,
                            "al r5 r3 r1 LSL 4",
                            "al_r5_r3_r1_LSL_4"},
                           {{al, r4, r11, r7, LSL, 17},
                            false,
                            al,
                            "al r4 r11 r7 LSL 17",
                            "al_r4_r11_r7_LSL_17"},
                           {{al, r12, r8, r3, LSL, 2},
                            false,
                            al,
                            "al r12 r8 r3 LSL 2",
                            "al_r12_r8_r3_LSL_2"},
                           {{al, r2, r11, r3, LSL, 13},
                            false,
                            al,
                            "al r2 r11 r3 LSL 13",
                            "al_r2_r11_r3_LSL_13"},
                           {{al, r11, r11, r4, ROR, 19},
                            false,
                            al,
                            "al r11 r11 r4 ROR 19",
                            "al_r11_r11_r4_ROR_19"},
                           {{al, r5, r1, r3, LSL, 4},
                            false,
                            al,
                            "al r5 r1 r3 LSL 4",
                            "al_r5_r1_r3_LSL_4"},
                           {{al, r2, r5, r7, ROR, 20},
                            false,
                            al,
                            "al r2 r5 r7 ROR 20",
                            "al_r2_r5_r7_ROR_20"},
                           {{al, r8, r8, r1, LSL, 24},
                            false,
                            al,
                            "al r8 r8 r1 LSL 24",
                            "al_r8_r8_r1_LSL_24"},
                           {{al, r7, r1, r0, LSL, 11},
                            false,
                            al,
                            "al r7 r1 r0 LSL 11",
                            "al_r7_r1_r0_LSL_11"},
                           {{al, r10, r5, r0, LSL, 17},
                            false,
                            al,
                            "al r10 r5 r0 LSL 17",
                            "al_r10_r5_r0_LSL_17"},
                           {{al, r14, r13, r13, ROR, 18},
                            false,
                            al,
                            "al r14 r13 r13 ROR 18",
                            "al_r14_r13_r13_ROR_18"},
                           {{al, r8, r3, r11, LSL, 4},
                            false,
                            al,
                            "al r8 r3 r11 LSL 4",
                            "al_r8_r3_r11_LSL_4"},
                           {{al, r1, r11, r10, LSL, 2},
                            false,
                            al,
                            "al r1 r11 r10 LSL 2",
                            "al_r1_r11_r10_LSL_2"},
                           {{al, r0, r2, r11, LSL, 25},
                            false,
                            al,
                            "al r0 r2 r11 LSL 25",
                            "al_r0_r2_r11_LSL_25"},
                           {{al, r0, r1, r12, LSL, 7},
                            false,
                            al,
                            "al r0 r1 r12 LSL 7",
                            "al_r0_r1_r12_LSL_7"},
                           {{al, r5, r0, r8, LSL, 19},
                            false,
                            al,
                            "al r5 r0 r8 LSL 19",
                            "al_r5_r0_r8_LSL_19"},
                           {{al, r1, r5, r8, ROR, 16},
                            false,
                            al,
                            "al r1 r5 r8 ROR 16",
                            "al_r1_r5_r8_ROR_16"},
                           {{al, r5, r11, r0, LSL, 7},
                            false,
                            al,
                            "al r5 r11 r0 LSL 7",
                            "al_r5_r11_r0_LSL_7"},
                           {{al, r4, r5, r9, LSL, 28},
                            false,
                            al,
                            "al r4 r5 r9 LSL 28",
                            "al_r4_r5_r9_LSL_28"},
                           {{al, r2, r6, r0, ROR, 5},
                            false,
                            al,
                            "al r2 r6 r0 ROR 5",
                            "al_r2_r6_r0_ROR_5"},
                           {{al, r8, r13, r4, ROR, 19},
                            false,
                            al,
                            "al r8 r13 r4 ROR 19",
                            "al_r8_r13_r4_ROR_19"},
                           {{al, r10, r11, r4, LSL, 27},
                            false,
                            al,
                            "al r10 r11 r4 LSL 27",
                            "al_r10_r11_r4_LSL_27"},
                           {{al, r2, r8, r10, ROR, 12},
                            false,
                            al,
                            "al r2 r8 r10 ROR 12",
                            "al_r2_r8_r10_ROR_12"},
                           {{al, r8, r11, r8, ROR, 30},
                            false,
                            al,
                            "al r8 r11 r8 ROR 30",
                            "al_r8_r11_r8_ROR_30"},
                           {{al, r7, r12, r14, LSL, 21},
                            false,
                            al,
                            "al r7 r12 r14 LSL 21",
                            "al_r7_r12_r14_LSL_21"},
                           {{al, r1, r7, r14, LSL, 18},
                            false,
                            al,
                            "al r1 r7 r14 LSL 18",
                            "al_r1_r7_r14_LSL_18"},
                           {{al, r1, r2, r11, ROR, 26},
                            false,
                            al,
                            "al r1 r2 r11 ROR 26",
                            "al_r1_r2_r11_ROR_26"},
                           {{al, r12, r10, r0, ROR, 10},
                            false,
                            al,
                            "al r12 r10 r0 ROR 10",
                            "al_r12_r10_r0_ROR_10"},
                           {{al, r4, r4, r10, ROR, 22},
                            false,
                            al,
                            "al r4 r4 r10 ROR 22",
                            "al_r4_r4_r10_ROR_22"},
                           {{al, r10, r10, r11, LSL, 25},
                            false,
                            al,
                            "al r10 r10 r11 LSL 25",
                            "al_r10_r10_r11_LSL_25"},
                           {{al, r5, r11, r12, LSL, 20},
                            false,
                            al,
                            "al r5 r11 r12 LSL 20",
                            "al_r5_r11_r12_LSL_20"},
                           {{al, r6, r14, r7, LSL, 26},
                            false,
                            al,
                            "al r6 r14 r7 LSL 26",
                            "al_r6_r14_r7_LSL_26"},
                           {{al, r10, r3, r3, LSL, 10},
                            false,
                            al,
                            "al r10 r3 r3 LSL 10",
                            "al_r10_r3_r3_LSL_10"},
                           {{al, r11, r3, r5, LSL, 24},
                            false,
                            al,
                            "al r11 r3 r5 LSL 24",
                            "al_r11_r3_r5_LSL_24"},
                           {{al, r9, r5, r10, ROR, 23},
                            false,
                            al,
                            "al r9 r5 r10 ROR 23",
                            "al_r9_r5_r10_ROR_23"},
                           {{al, r4, r6, r5, ROR, 28},
                            false,
                            al,
                            "al r4 r6 r5 ROR 28",
                            "al_r4_r6_r5_ROR_28"},
                           {{al, r9, r10, r4, ROR, 26},
                            false,
                            al,
                            "al r9 r10 r4 ROR 26",
                            "al_r9_r10_r4_ROR_26"},
                           {{al, r9, r0, r9, LSL, 2},
                            false,
                            al,
                            "al r9 r0 r9 LSL 2",
                            "al_r9_r0_r9_LSL_2"},
                           {{al, r4, r12, r8, LSL, 23},
                            false,
                            al,
                            "al r4 r12 r8 LSL 23",
                            "al_r4_r12_r8_LSL_23"},
                           {{al, r7, r9, r11, LSL, 18},
                            false,
                            al,
                            "al r7 r9 r11 LSL 18",
                            "al_r7_r9_r11_LSL_18"},
                           {{al, r5, r2, r3, LSL, 19},
                            false,
                            al,
                            "al r5 r2 r3 LSL 19",
                            "al_r5_r2_r3_LSL_19"},
                           {{al, r5, r5, r1, ROR, 10},
                            false,
                            al,
                            "al r5 r5 r1 ROR 10",
                            "al_r5_r5_r1_ROR_10"},
                           {{al, r3, r0, r7, ROR, 27},
                            false,
                            al,
                            "al r3 r0 r7 ROR 27",
                            "al_r3_r0_r7_ROR_27"},
                           {{al, r8, r12, r8, ROR, 14},
                            false,
                            al,
                            "al r8 r12 r8 ROR 14",
                            "al_r8_r12_r8_ROR_14"},
                           {{al, r3, r8, r2, LSL, 25},
                            false,
                            al,
                            "al r3 r8 r2 LSL 25",
                            "al_r3_r8_r2_LSL_25"},
                           {{al, r8, r5, r8, LSL, 24},
                            false,
                            al,
                            "al r8 r5 r8 LSL 24",
                            "al_r8_r5_r8_LSL_24"},
                           {{al, r10, r2, r9, LSL, 23},
                            false,
                            al,
                            "al r10 r2 r9 LSL 23",
                            "al_r10_r2_r9_LSL_23"},
                           {{al, r13, r11, r3, ROR, 25},
                            false,
                            al,
                            "al r13 r11 r3 ROR 25",
                            "al_r13_r11_r3_ROR_25"},
                           {{al, r2, r13, r2, ROR, 1},
                            false,
                            al,
                            "al r2 r13 r2 ROR 1",
                            "al_r2_r13_r2_ROR_1"},
                           {{al, r9, r7, r7, ROR, 18},
                            false,
                            al,
                            "al r9 r7 r7 ROR 18",
                            "al_r9_r7_r7_ROR_18"},
                           {{al, r13, r13, r4, ROR, 15},
                            false,
                            al,
                            "al r13 r13 r4 ROR 15",
                            "al_r13_r13_r4_ROR_15"},
                           {{al, r1, r2, r0, LSL, 1},
                            false,
                            al,
                            "al r1 r2 r0 LSL 1",
                            "al_r1_r2_r0_LSL_1"},
                           {{al, r0, r14, r1, LSL, 7},
                            false,
                            al,
                            "al r0 r14 r1 LSL 7",
                            "al_r0_r14_r1_LSL_7"},
                           {{al, r2, r2, r3, LSL, 18},
                            false,
                            al,
                            "al r2 r2 r3 LSL 18",
                            "al_r2_r2_r3_LSL_18"},
                           {{al, r12, r12, r10, ROR, 22},
                            false,
                            al,
                            "al r12 r12 r10 ROR 22",
                            "al_r12_r12_r10_ROR_22"},
                           {{al, r12, r10, r2, ROR, 13},
                            false,
                            al,
                            "al r12 r10 r2 ROR 13",
                            "al_r12_r10_r2_ROR_13"},
                           {{al, r7, r3, r11, LSL, 23},
                            false,
                            al,
                            "al r7 r3 r11 LSL 23",
                            "al_r7_r3_r11_LSL_23"},
                           {{al, r4, r7, r14, LSL, 10},
                            false,
                            al,
                            "al r4 r7 r14 LSL 10",
                            "al_r4_r7_r14_LSL_10"},
                           {{al, r3, r7, r5, ROR, 27},
                            false,
                            al,
                            "al r3 r7 r5 ROR 27",
                            "al_r3_r7_r5_ROR_27"},
                           {{al, r5, r11, r5, ROR, 24},
                            false,
                            al,
                            "al r5 r11 r5 ROR 24",
                            "al_r5_r11_r5_ROR_24"},
                           {{al, r12, r0, r6, ROR, 29},
                            false,
                            al,
                            "al r12 r0 r6 ROR 29",
                            "al_r12_r0_r6_ROR_29"},
                           {{al, r14, r3, r8, LSL, 26},
                            false,
                            al,
                            "al r14 r3 r8 LSL 26",
                            "al_r14_r3_r8_LSL_26"},
                           {{al, r12, r10, r3, LSL, 10},
                            false,
                            al,
                            "al r12 r10 r3 LSL 10",
                            "al_r12_r10_r3_LSL_10"},
                           {{al, r3, r8, r6, ROR, 16},
                            false,
                            al,
                            "al r3 r8 r6 ROR 16",
                            "al_r3_r8_r6_ROR_16"},
                           {{al, r14, r1, r1, LSL, 23},
                            false,
                            al,
                            "al r14 r1 r1 LSL 23",
                            "al_r14_r1_r1_LSL_23"},
                           {{al, r14, r1, r0, LSL, 18},
                            false,
                            al,
                            "al r14 r1 r0 LSL 18",
                            "al_r14_r1_r0_LSL_18"},
                           {{al, r7, r1, r8, LSL, 29},
                            false,
                            al,
                            "al r7 r1 r8 LSL 29",
                            "al_r7_r1_r8_LSL_29"},
                           {{al, r8, r12, r1, ROR, 22},
                            false,
                            al,
                            "al r8 r12 r1 ROR 22",
                            "al_r8_r12_r1_ROR_22"},
                           {{al, r8, r12, r10, ROR, 10},
                            false,
                            al,
                            "al r8 r12 r10 ROR 10",
                            "al_r8_r12_r10_ROR_10"},
                           {{al, r1, r14, r3, ROR, 7},
                            false,
                            al,
                            "al r1 r14 r3 ROR 7",
                            "al_r1_r14_r3_ROR_7"},
                           {{al, r3, r4, r3, LSL, 20},
                            false,
                            al,
                            "al r3 r4 r3 LSL 20",
                            "al_r3_r4_r3_LSL_20"},
                           {{al, r2, r13, r0, LSL, 7},
                            false,
                            al,
                            "al r2 r13 r0 LSL 7",
                            "al_r2_r13_r0_LSL_7"},
                           {{al, r13, r0, r9, ROR, 20},
                            false,
                            al,
                            "al r13 r0 r9 ROR 20",
                            "al_r13_r0_r9_ROR_20"},
                           {{al, r6, r4, r14, ROR, 5},
                            false,
                            al,
                            "al r6 r4 r14 ROR 5",
                            "al_r6_r4_r14_ROR_5"},
                           {{al, r12, r8, r9, ROR, 3},
                            false,
                            al,
                            "al r12 r8 r9 ROR 3",
                            "al_r12_r8_r9_ROR_3"},
                           {{al, r0, r11, r2, LSL, 19},
                            false,
                            al,
                            "al r0 r11 r2 LSL 19",
                            "al_r0_r11_r2_LSL_19"},
                           {{al, r2, r3, r3, LSL, 8},
                            false,
                            al,
                            "al r2 r3 r3 LSL 8",
                            "al_r2_r3_r3_LSL_8"},
                           {{al, r5, r1, r1, ROR, 26},
                            false,
                            al,
                            "al r5 r1 r1 ROR 26",
                            "al_r5_r1_r1_ROR_26"},
                           {{al, r4, r4, r13, ROR, 31},
                            false,
                            al,
                            "al r4 r4 r13 ROR 31",
                            "al_r4_r4_r13_ROR_31"},
                           {{al, r4, r6, r8, ROR, 11},
                            false,
                            al,
                            "al r4 r6 r8 ROR 11",
                            "al_r4_r6_r8_ROR_11"},
                           {{al, r4, r10, r13, LSL, 28},
                            false,
                            al,
                            "al r4 r10 r13 LSL 28",
                            "al_r4_r10_r13_LSL_28"},
                           {{al, r0, r8, r5, LSL, 19},
                            false,
                            al,
                            "al r0 r8 r5 LSL 19",
                            "al_r0_r8_r5_LSL_19"},
                           {{al, r14, r0, r7, ROR, 10},
                            false,
                            al,
                            "al r14 r0 r7 ROR 10",
                            "al_r14_r0_r7_ROR_10"},
                           {{al, r9, r10, r9, ROR, 13},
                            false,
                            al,
                            "al r9 r10 r9 ROR 13",
                            "al_r9_r10_r9_ROR_13"},
                           {{al, r5, r1, r7, LSL, 31},
                            false,
                            al,
                            "al r5 r1 r7 LSL 31",
                            "al_r5_r1_r7_LSL_31"},
                           {{al, r8, r4, r12, ROR, 8},
                            false,
                            al,
                            "al r8 r4 r12 ROR 8",
                            "al_r8_r4_r12_ROR_8"},
                           {{al, r8, r13, r0, LSL, 4},
                            false,
                            al,
                            "al r8 r13 r0 LSL 4",
                            "al_r8_r13_r0_LSL_4"},
                           {{al, r10, r4, r10, LSL, 19},
                            false,
                            al,
                            "al r10 r4 r10 LSL 19",
                            "al_r10_r4_r10_LSL_19"},
                           {{al, r5, r2, r3, LSL, 5},
                            false,
                            al,
                            "al r5 r2 r3 LSL 5",
                            "al_r5_r2_r3_LSL_5"},
                           {{al, r1, r1, r2, LSL, 17},
                            false,
                            al,
                            "al r1 r1 r2 LSL 17",
                            "al_r1_r1_r2_LSL_17"},
                           {{al, r9, r2, r13, ROR, 13},
                            false,
                            al,
                            "al r9 r2 r13 ROR 13",
                            "al_r9_r2_r13_ROR_13"},
                           {{al, r2, r5, r5, ROR, 8},
                            false,
                            al,
                            "al r2 r5 r5 ROR 8",
                            "al_r2_r5_r5_ROR_8"},
                           {{al, r11, r11, r10, ROR, 31},
                            false,
                            al,
                            "al r11 r11 r10 ROR 31",
                            "al_r11_r11_r10_ROR_31"},
                           {{al, r13, r14, r13, LSL, 23},
                            false,
                            al,
                            "al r13 r14 r13 LSL 23",
                            "al_r13_r14_r13_LSL_23"},
                           {{al, r9, r0, r3, ROR, 6},
                            false,
                            al,
                            "al r9 r0 r3 ROR 6",
                            "al_r9_r0_r3_ROR_6"},
                           {{al, r10, r10, r11, LSL, 9},
                            false,
                            al,
                            "al r10 r10 r11 LSL 9",
                            "al_r10_r10_r11_LSL_9"},
                           {{al, r13, r10, r11, ROR, 31},
                            false,
                            al,
                            "al r13 r10 r11 ROR 31",
                            "al_r13_r10_r11_ROR_31"},
                           {{al, r8, r8, r10, LSL, 23},
                            false,
                            al,
                            "al r8 r8 r10 LSL 23",
                            "al_r8_r8_r10_LSL_23"},
                           {{al, r13, r13, r10, ROR, 27},
                            false,
                            al,
                            "al r13 r13 r10 ROR 27",
                            "al_r13_r13_r10_ROR_27"},
                           {{al, r6, r4, r7, LSL, 19},
                            false,
                            al,
                            "al r6 r4 r7 LSL 19",
                            "al_r6_r4_r7_LSL_19"},
                           {{al, r6, r1, r7, LSL, 23},
                            false,
                            al,
                            "al r6 r1 r7 LSL 23",
                            "al_r6_r1_r7_LSL_23"},
                           {{al, r11, r13, r9, ROR, 2},
                            false,
                            al,
                            "al r11 r13 r9 ROR 2",
                            "al_r11_r13_r9_ROR_2"},
                           {{al, r14, r13, r8, LSL, 11},
                            false,
                            al,
                            "al r14 r13 r8 LSL 11",
                            "al_r14_r13_r8_LSL_11"},
                           {{al, r10, r11, r8, ROR, 11},
                            false,
                            al,
                            "al r10 r11 r8 ROR 11",
                            "al_r10_r11_r8_ROR_11"},
                           {{al, r5, r5, r1, ROR, 15},
                            false,
                            al,
                            "al r5 r5 r1 ROR 15",
                            "al_r5_r5_r1_ROR_15"},
                           {{al, r1, r3, r0, LSL, 14},
                            false,
                            al,
                            "al r1 r3 r0 LSL 14",
                            "al_r1_r3_r0_LSL_14"},
                           {{al, r11, r4, r0, ROR, 29},
                            false,
                            al,
                            "al r11 r4 r0 ROR 29",
                            "al_r11_r4_r0_ROR_29"},
                           {{al, r6, r11, r10, ROR, 25},
                            false,
                            al,
                            "al r6 r11 r10 ROR 25",
                            "al_r6_r11_r10_ROR_25"},
                           {{al, r8, r3, r9, ROR, 15},
                            false,
                            al,
                            "al r8 r3 r9 ROR 15",
                            "al_r8_r3_r9_ROR_15"},
                           {{al, r3, r12, r14, LSL, 23},
                            false,
                            al,
                            "al r3 r12 r14 LSL 23",
                            "al_r3_r12_r14_LSL_23"},
                           {{al, r14, r14, r6, ROR, 23},
                            false,
                            al,
                            "al r14 r14 r6 ROR 23",
                            "al_r14_r14_r6_ROR_23"},
                           {{al, r6, r8, r8, ROR, 25},
                            false,
                            al,
                            "al r6 r8 r8 ROR 25",
                            "al_r6_r8_r8_ROR_25"},
                           {{al, r5, r5, r2, LSL, 17},
                            false,
                            al,
                            "al r5 r5 r2 LSL 17",
                            "al_r5_r5_r2_LSL_17"},
                           {{al, r13, r4, r6, ROR, 13},
                            false,
                            al,
                            "al r13 r4 r6 ROR 13",
                            "al_r13_r4_r6_ROR_13"},
                           {{al, r10, r9, r0, LSL, 25},
                            false,
                            al,
                            "al r10 r9 r0 LSL 25",
                            "al_r10_r9_r0_LSL_25"},
                           {{al, r11, r2, r5, ROR, 15},
                            false,
                            al,
                            "al r11 r2 r5 ROR 15",
                            "al_r11_r2_r5_ROR_15"},
                           {{al, r4, r13, r4, LSL, 8},
                            false,
                            al,
                            "al r4 r13 r4 LSL 8",
                            "al_r4_r13_r4_LSL_8"},
                           {{al, r13, r6, r5, LSL, 31},
                            false,
                            al,
                            "al r13 r6 r5 LSL 31",
                            "al_r13_r6_r5_LSL_31"},
                           {{al, r3, r5, r6, ROR, 25},
                            false,
                            al,
                            "al r3 r5 r6 ROR 25",
                            "al_r3_r5_r6_ROR_25"},
                           {{al, r7, r7, r12, ROR, 12},
                            false,
                            al,
                            "al r7 r7 r12 ROR 12",
                            "al_r7_r7_r12_ROR_12"},
                           {{al, r6, r10, r6, ROR, 18},
                            false,
                            al,
                            "al r6 r10 r6 ROR 18",
                            "al_r6_r10_r6_ROR_18"},
                           {{al, r8, r14, r14, LSL, 30},
                            false,
                            al,
                            "al r8 r14 r14 LSL 30",
                            "al_r8_r14_r14_LSL_30"},
                           {{al, r0, r0, r2, LSL, 4},
                            false,
                            al,
                            "al r0 r0 r2 LSL 4",
                            "al_r0_r0_r2_LSL_4"},
                           {{al, r11, r2, r3, ROR, 10},
                            false,
                            al,
                            "al r11 r2 r3 ROR 10",
                            "al_r11_r2_r3_ROR_10"},
                           {{al, r2, r6, r14, ROR, 29},
                            false,
                            al,
                            "al r2 r6 r14 ROR 29",
                            "al_r2_r6_r14_ROR_29"},
                           {{al, r4, r5, r11, ROR, 22},
                            false,
                            al,
                            "al r4 r5 r11 ROR 22",
                            "al_r4_r5_r11_ROR_22"},
                           {{al, r13, r5, r1, LSL, 8},
                            false,
                            al,
                            "al r13 r5 r1 LSL 8",
                            "al_r13_r5_r1_LSL_8"},
                           {{al, r9, r3, r0, ROR, 25},
                            false,
                            al,
                            "al r9 r3 r0 ROR 25",
                            "al_r9_r3_r0_ROR_25"},
                           {{al, r10, r0, r14, LSL, 11},
                            false,
                            al,
                            "al r10 r0 r14 LSL 11",
                            "al_r10_r0_r14_LSL_11"},
                           {{al, r8, r13, r13, ROR, 6},
                            false,
                            al,
                            "al r8 r13 r13 ROR 6",
                            "al_r8_r13_r13_ROR_6"},
                           {{al, r10, r7, r14, LSL, 10},
                            false,
                            al,
                            "al r10 r7 r14 LSL 10",
                            "al_r10_r7_r14_LSL_10"},
                           {{al, r9, r6, r12, ROR, 31},
                            false,
                            al,
                            "al r9 r6 r12 ROR 31",
                            "al_r9_r6_r12_ROR_31"},
                           {{al, r9, r5, r0, ROR, 1},
                            false,
                            al,
                            "al r9 r5 r0 ROR 1",
                            "al_r9_r5_r0_ROR_1"},
                           {{al, r0, r10, r12, LSL, 11},
                            false,
                            al,
                            "al r0 r10 r12 LSL 11",
                            "al_r0_r10_r12_LSL_11"},
                           {{al, r8, r0, r8, ROR, 15},
                            false,
                            al,
                            "al r8 r0 r8 ROR 15",
                            "al_r8_r0_r8_ROR_15"},
                           {{al, r13, r2, r1, LSL, 21},
                            false,
                            al,
                            "al r13 r2 r1 LSL 21",
                            "al_r13_r2_r1_LSL_21"},
                           {{al, r3, r0, r9, LSL, 29},
                            false,
                            al,
                            "al r3 r0 r9 LSL 29",
                            "al_r3_r0_r9_LSL_29"},
                           {{al, r14, r10, r11, LSL, 17},
                            false,
                            al,
                            "al r14 r10 r11 LSL 17",
                            "al_r14_r10_r11_LSL_17"},
                           {{al, r13, r4, r0, LSL, 17},
                            false,
                            al,
                            "al r13 r4 r0 LSL 17",
                            "al_r13_r4_r0_LSL_17"},
                           {{al, r0, r3, r4, LSL, 6},
                            false,
                            al,
                            "al r0 r3 r4 LSL 6",
                            "al_r0_r3_r4_LSL_6"},
                           {{al, r13, r9, r2, LSL, 21},
                            false,
                            al,
                            "al r13 r9 r2 LSL 21",
                            "al_r13_r9_r2_LSL_21"},
                           {{al, r13, r5, r13, LSL, 23},
                            false,
                            al,
                            "al r13 r5 r13 LSL 23",
                            "al_r13_r5_r13_LSL_23"},
                           {{al, r14, r10, r2, LSL, 8},
                            false,
                            al,
                            "al r14 r10 r2 LSL 8",
                            "al_r14_r10_r2_LSL_8"},
                           {{al, r12, r11, r12, LSL, 13},
                            false,
                            al,
                            "al r12 r11 r12 LSL 13",
                            "al_r12_r11_r12_LSL_13"},
                           {{al, r10, r2, r12, ROR, 23},
                            false,
                            al,
                            "al r10 r2 r12 ROR 23",
                            "al_r10_r2_r12_ROR_23"},
                           {{al, r5, r5, r8, ROR, 28},
                            false,
                            al,
                            "al r5 r5 r8 ROR 28",
                            "al_r5_r5_r8_ROR_28"},
                           {{al, r0, r14, r12, ROR, 19},
                            false,
                            al,
                            "al r0 r14 r12 ROR 19",
                            "al_r0_r14_r12_ROR_19"},
                           {{al, r8, r13, r11, LSL, 24},
                            false,
                            al,
                            "al r8 r13 r11 LSL 24",
                            "al_r8_r13_r11_LSL_24"},
                           {{al, r9, r5, r3, ROR, 30},
                            false,
                            al,
                            "al r9 r5 r3 ROR 30",
                            "al_r9_r5_r3_ROR_30"},
                           {{al, r9, r10, r7, ROR, 22},
                            false,
                            al,
                            "al r9 r10 r7 ROR 22",
                            "al_r9_r10_r7_ROR_22"},
                           {{al, r10, r3, r10, LSL, 18},
                            false,
                            al,
                            "al r10 r3 r10 LSL 18",
                            "al_r10_r3_r10_LSL_18"},
                           {{al, r7, r3, r14, ROR, 22},
                            false,
                            al,
                            "al r7 r3 r14 ROR 22",
                            "al_r7_r3_r14_ROR_22"},
                           {{al, r11, r4, r4, LSL, 20},
                            false,
                            al,
                            "al r11 r4 r4 LSL 20",
                            "al_r11_r4_r4_LSL_20"},
                           {{al, r7, r13, r14, ROR, 25},
                            false,
                            al,
                            "al r7 r13 r14 ROR 25",
                            "al_r7_r13_r14_ROR_25"},
                           {{al, r10, r10, r1, ROR, 5},
                            false,
                            al,
                            "al r10 r10 r1 ROR 5",
                            "al_r10_r10_r1_ROR_5"},
                           {{al, r4, r12, r6, LSL, 6},
                            false,
                            al,
                            "al r4 r12 r6 LSL 6",
                            "al_r4_r12_r6_LSL_6"},
                           {{al, r3, r6, r9, ROR, 3},
                            false,
                            al,
                            "al r3 r6 r9 ROR 3",
                            "al_r3_r6_r9_ROR_3"},
                           {{al, r14, r3, r7, LSL, 26},
                            false,
                            al,
                            "al r14 r3 r7 LSL 26",
                            "al_r14_r3_r7_LSL_26"},
                           {{al, r0, r8, r10, LSL, 10},
                            false,
                            al,
                            "al r0 r8 r10 LSL 10",
                            "al_r0_r8_r10_LSL_10"},
                           {{al, r13, r10, r7, ROR, 19},
                            false,
                            al,
                            "al r13 r10 r7 ROR 19",
                            "al_r13_r10_r7_ROR_19"},
                           {{al, r14, r1, r6, ROR, 27},
                            false,
                            al,
                            "al r14 r1 r6 ROR 27",
                            "al_r14_r1_r6_ROR_27"},
                           {{al, r0, r5, r13, LSL, 18},
                            false,
                            al,
                            "al r0 r5 r13 LSL 18",
                            "al_r0_r5_r13_LSL_18"},
                           {{al, r10, r9, r0, LSL, 15},
                            false,
                            al,
                            "al r10 r9 r0 LSL 15",
                            "al_r10_r9_r0_LSL_15"},
                           {{al, r12, r8, r13, ROR, 19},
                            false,
                            al,
                            "al r12 r8 r13 ROR 19",
                            "al_r12_r8_r13_ROR_19"},
                           {{al, r8, r0, r11, LSL, 31},
                            false,
                            al,
                            "al r8 r0 r11 LSL 31",
                            "al_r8_r0_r11_LSL_31"},
                           {{al, r8, r14, r0, ROR, 20},
                            false,
                            al,
                            "al r8 r14 r0 ROR 20",
                            "al_r8_r14_r0_ROR_20"},
                           {{al, r8, r7, r6, ROR, 14},
                            false,
                            al,
                            "al r8 r7 r6 ROR 14",
                            "al_r8_r7_r6_ROR_14"},
                           {{al, r10, r9, r5, LSL, 21},
                            false,
                            al,
                            "al r10 r9 r5 LSL 21",
                            "al_r10_r9_r5_LSL_21"},
                           {{al, r9, r8, r13, ROR, 28},
                            false,
                            al,
                            "al r9 r8 r13 ROR 28",
                            "al_r9_r8_r13_ROR_28"},
                           {{al, r12, r12, r12, ROR, 25},
                            false,
                            al,
                            "al r12 r12 r12 ROR 25",
                            "al_r12_r12_r12_ROR_25"},
                           {{al, r5, r11, r4, ROR, 12},
                            false,
                            al,
                            "al r5 r11 r4 ROR 12",
                            "al_r5_r11_r4_ROR_12"},
                           {{al, r1, r7, r10, ROR, 13},
                            false,
                            al,
                            "al r1 r7 r10 ROR 13",
                            "al_r1_r7_r10_ROR_13"},
                           {{al, r14, r12, r2, LSL, 19},
                            false,
                            al,
                            "al r14 r12 r2 LSL 19",
                            "al_r14_r12_r2_LSL_19"},
                           {{al, r0, r5, r14, LSL, 20},
                            false,
                            al,
                            "al r0 r5 r14 LSL 20",
                            "al_r0_r5_r14_LSL_20"},
                           {{al, r12, r4, r3, ROR, 27},
                            false,
                            al,
                            "al r12 r4 r3 ROR 27",
                            "al_r12_r4_r3_ROR_27"},
                           {{al, r9, r3, r1, ROR, 22},
                            false,
                            al,
                            "al r9 r3 r1 ROR 22",
                            "al_r9_r3_r1_ROR_22"},
                           {{al, r2, r12, r7, ROR, 23},
                            false,
                            al,
                            "al r2 r12 r7 ROR 23",
                            "al_r2_r12_r7_ROR_23"},
                           {{al, r10, r4, r8, ROR, 11},
                            false,
                            al,
                            "al r10 r4 r8 ROR 11",
                            "al_r10_r4_r8_ROR_11"},
                           {{al, r6, r0, r2, LSL, 8},
                            false,
                            al,
                            "al r6 r0 r2 LSL 8",
                            "al_r6_r0_r2_LSL_8"},
                           {{al, r10, r3, r0, LSL, 1},
                            false,
                            al,
                            "al r10 r3 r0 LSL 1",
                            "al_r10_r3_r0_LSL_1"},
                           {{al, r6, r6, r4, LSL, 1},
                            false,
                            al,
                            "al r6 r6 r4 LSL 1",
                            "al_r6_r6_r4_LSL_1"},
                           {{al, r13, r12, r13, ROR, 13},
                            false,
                            al,
                            "al r13 r12 r13 ROR 13",
                            "al_r13_r12_r13_ROR_13"},
                           {{al, r0, r9, r10, ROR, 1},
                            false,
                            al,
                            "al r0 r9 r10 ROR 1",
                            "al_r0_r9_r10_ROR_1"},
                           {{al, r9, r13, r9, ROR, 16},
                            false,
                            al,
                            "al r9 r13 r9 ROR 16",
                            "al_r9_r13_r9_ROR_16"},
                           {{al, r0, r6, r2, LSL, 4},
                            false,
                            al,
                            "al r0 r6 r2 LSL 4",
                            "al_r0_r6_r2_LSL_4"},
                           {{al, r9, r2, r11, LSL, 31},
                            false,
                            al,
                            "al r9 r2 r11 LSL 31",
                            "al_r9_r2_r11_LSL_31"},
                           {{al, r12, r12, r13, ROR, 19},
                            false,
                            al,
                            "al r12 r12 r13 ROR 19",
                            "al_r12_r12_r13_ROR_19"},
                           {{al, r7, r14, r2, ROR, 23},
                            false,
                            al,
                            "al r7 r14 r2 ROR 23",
                            "al_r7_r14_r2_ROR_23"},
                           {{al, r7, r1, r3, LSL, 26},
                            false,
                            al,
                            "al r7 r1 r3 LSL 26",
                            "al_r7_r1_r3_LSL_26"},
                           {{al, r13, r6, r12, ROR, 26},
                            false,
                            al,
                            "al r13 r6 r12 ROR 26",
                            "al_r13_r6_r12_ROR_26"},
                           {{al, r10, r14, r12, ROR, 5},
                            false,
                            al,
                            "al r10 r14 r12 ROR 5",
                            "al_r10_r14_r12_ROR_5"},
                           {{al, r5, r9, r12, LSL, 9},
                            false,
                            al,
                            "al r5 r9 r12 LSL 9",
                            "al_r5_r9_r12_LSL_9"},
                           {{al, r2, r7, r2, ROR, 10},
                            false,
                            al,
                            "al r2 r7 r2 ROR 10",
                            "al_r2_r7_r2_ROR_10"},
                           {{al, r12, r12, r8, ROR, 6},
                            false,
                            al,
                            "al r12 r12 r8 ROR 6",
                            "al_r12_r12_r8_ROR_6"},
                           {{al, r1, r13, r13, ROR, 24},
                            false,
                            al,
                            "al r1 r13 r13 ROR 24",
                            "al_r1_r13_r13_ROR_24"},
                           {{al, r6, r10, r10, ROR, 26},
                            false,
                            al,
                            "al r6 r10 r10 ROR 26",
                            "al_r6_r10_r10_ROR_26"},
                           {{al, r13, r9, r1, LSL, 18},
                            false,
                            al,
                            "al r13 r9 r1 LSL 18",
                            "al_r13_r9_r1_LSL_18"},
                           {{al, r6, r1, r4, ROR, 21},
                            false,
                            al,
                            "al r6 r1 r4 ROR 21",
                            "al_r6_r1_r4_ROR_21"},
                           {{al, r0, r3, r3, ROR, 18},
                            false,
                            al,
                            "al r0 r3 r3 ROR 18",
                            "al_r0_r3_r3_ROR_18"},
                           {{al, r1, r9, r5, LSL, 29},
                            false,
                            al,
                            "al r1 r9 r5 LSL 29",
                            "al_r1_r9_r5_LSL_29"},
                           {{al, r11, r8, r7, ROR, 18},
                            false,
                            al,
                            "al r11 r8 r7 ROR 18",
                            "al_r11_r8_r7_ROR_18"},
                           {{al, r2, r3, r12, LSL, 7},
                            false,
                            al,
                            "al r2 r3 r12 LSL 7",
                            "al_r2_r3_r12_LSL_7"},
                           {{al, r8, r3, r9, LSL, 18},
                            false,
                            al,
                            "al r8 r3 r9 LSL 18",
                            "al_r8_r3_r9_LSL_18"},
                           {{al, r8, r12, r1, LSL, 11},
                            false,
                            al,
                            "al r8 r12 r1 LSL 11",
                            "al_r8_r12_r1_LSL_11"},
                           {{al, r14, r9, r5, ROR, 21},
                            false,
                            al,
                            "al r14 r9 r5 ROR 21",
                            "al_r14_r9_r5_ROR_21"},
                           {{al, r0, r6, r12, ROR, 26},
                            false,
                            al,
                            "al r0 r6 r12 ROR 26",
                            "al_r0_r6_r12_ROR_26"},
                           {{al, r3, r6, r14, LSL, 14},
                            false,
                            al,
                            "al r3 r6 r14 LSL 14",
                            "al_r3_r6_r14_LSL_14"},
                           {{al, r11, r0, r9, LSL, 9},
                            false,
                            al,
                            "al r11 r0 r9 LSL 9",
                            "al_r11_r0_r9_LSL_9"},
                           {{al, r8, r13, r7, LSL, 9},
                            false,
                            al,
                            "al r8 r13 r7 LSL 9",
                            "al_r8_r13_r7_LSL_9"},
                           {{al, r3, r1, r13, LSL, 23},
                            false,
                            al,
                            "al r3 r1 r13 LSL 23",
                            "al_r3_r1_r13_LSL_23"},
                           {{al, r12, r13, r13, ROR, 4},
                            false,
                            al,
                            "al r12 r13 r13 ROR 4",
                            "al_r12_r13_r13_ROR_4"},
                           {{al, r10, r14, r9, ROR, 13},
                            false,
                            al,
                            "al r10 r14 r9 ROR 13",
                            "al_r10_r14_r9_ROR_13"},
                           {{al, r14, r5, r1, LSL, 22},
                            false,
                            al,
                            "al r14 r5 r1 LSL 22",
                            "al_r14_r5_r1_LSL_22"},
                           {{al, r11, r8, r8, ROR, 28},
                            false,
                            al,
                            "al r11 r8 r8 ROR 28",
                            "al_r11_r8_r8_ROR_28"},
                           {{al, r0, r8, r12, ROR, 19},
                            false,
                            al,
                            "al r0 r8 r12 ROR 19",
                            "al_r0_r8_r12_ROR_19"},
                           {{al, r11, r3, r1, ROR, 6},
                            false,
                            al,
                            "al r11 r3 r1 ROR 6",
                            "al_r11_r3_r1_ROR_6"},
                           {{al, r2, r7, r2, ROR, 5},
                            false,
                            al,
                            "al r2 r7 r2 ROR 5",
                            "al_r2_r7_r2_ROR_5"},
                           {{al, r11, r14, r2, ROR, 14},
                            false,
                            al,
                            "al r11 r14 r2 ROR 14",
                            "al_r11_r14_r2_ROR_14"},
                           {{al, r9, r13, r7, LSL, 27},
                            false,
                            al,
                            "al r9 r13 r7 LSL 27",
                            "al_r9_r13_r7_LSL_27"},
                           {{al, r0, r0, r3, ROR, 29},
                            false,
                            al,
                            "al r0 r0 r3 ROR 29",
                            "al_r0_r0_r3_ROR_29"},
                           {{al, r9, r12, r7, LSL, 24},
                            false,
                            al,
                            "al r9 r12 r7 LSL 24",
                            "al_r9_r12_r7_LSL_24"},
                           {{al, r8, r5, r4, LSL, 10},
                            false,
                            al,
                            "al r8 r5 r4 LSL 10",
                            "al_r8_r5_r4_LSL_10"},
                           {{al, r0, r2, r12, ROR, 10},
                            false,
                            al,
                            "al r0 r2 r12 ROR 10",
                            "al_r0_r2_r12_ROR_10"},
                           {{al, r6, r0, r5, ROR, 16},
                            false,
                            al,
                            "al r6 r0 r5 ROR 16",
                            "al_r6_r0_r5_ROR_16"},
                           {{al, r9, r9, r14, ROR, 2},
                            false,
                            al,
                            "al r9 r9 r14 ROR 2",
                            "al_r9_r9_r14_ROR_2"},
                           {{al, r0, r0, r7, ROR, 28},
                            false,
                            al,
                            "al r0 r0 r7 ROR 28",
                            "al_r0_r0_r7_ROR_28"},
                           {{al, r2, r11, r12, LSL, 16},
                            false,
                            al,
                            "al r2 r11 r12 LSL 16",
                            "al_r2_r11_r12_LSL_16"},
                           {{al, r14, r0, r8, ROR, 13},
                            false,
                            al,
                            "al r14 r0 r8 ROR 13",
                            "al_r14_r0_r8_ROR_13"},
                           {{al, r3, r4, r3, LSL, 2},
                            false,
                            al,
                            "al r3 r4 r3 LSL 2",
                            "al_r3_r4_r3_LSL_2"},
                           {{al, r11, r6, r4, ROR, 25},
                            false,
                            al,
                            "al r11 r6 r4 ROR 25",
                            "al_r11_r6_r4_ROR_25"},
                           {{al, r14, r1, r12, LSL, 4},
                            false,
                            al,
                            "al r14 r1 r12 LSL 4",
                            "al_r14_r1_r12_LSL_4"},
                           {{al, r9, r2, r6, LSL, 12},
                            false,
                            al,
                            "al r9 r2 r6 LSL 12",
                            "al_r9_r2_r6_LSL_12"},
                           {{al, r10, r9, r2, ROR, 26},
                            false,
                            al,
                            "al r10 r9 r2 ROR 26",
                            "al_r10_r9_r2_ROR_26"},
                           {{al, r2, r3, r10, ROR, 2},
                            false,
                            al,
                            "al r2 r3 r10 ROR 2",
                            "al_r2_r3_r10_ROR_2"},
                           {{al, r6, r7, r9, LSL, 12},
                            false,
                            al,
                            "al r6 r7 r9 LSL 12",
                            "al_r6_r7_r9_LSL_12"},
                           {{al, r4, r1, r7, LSL, 6},
                            false,
                            al,
                            "al r4 r1 r7 LSL 6",
                            "al_r4_r1_r7_LSL_6"},
                           {{al, r4, r3, r13, ROR, 31},
                            false,
                            al,
                            "al r4 r3 r13 ROR 31",
                            "al_r4_r3_r13_ROR_31"},
                           {{al, r14, r1, r0, ROR, 11},
                            false,
                            al,
                            "al r14 r1 r0 ROR 11",
                            "al_r14_r1_r0_ROR_11"},
                           {{al, r4, r3, r9, ROR, 18},
                            false,
                            al,
                            "al r4 r3 r9 ROR 18",
                            "al_r4_r3_r9_ROR_18"},
                           {{al, r4, r5, r2, ROR, 26},
                            false,
                            al,
                            "al r4 r5 r2 ROR 26",
                            "al_r4_r5_r2_ROR_26"},
                           {{al, r11, r13, r9, LSL, 1},
                            false,
                            al,
                            "al r11 r13 r9 LSL 1",
                            "al_r11_r13_r9_LSL_1"},
                           {{al, r6, r13, r8, LSL, 31},
                            false,
                            al,
                            "al r6 r13 r8 LSL 31",
                            "al_r6_r13_r8_LSL_31"},
                           {{al, r8, r6, r5, LSL, 7},
                            false,
                            al,
                            "al r8 r6 r5 LSL 7",
                            "al_r8_r6_r5_LSL_7"},
                           {{al, r3, r12, r11, LSL, 29},
                            false,
                            al,
                            "al r3 r12 r11 LSL 29",
                            "al_r3_r12_r11_LSL_29"},
                           {{al, r4, r11, r3, ROR, 25},
                            false,
                            al,
                            "al r4 r11 r3 ROR 25",
                            "al_r4_r11_r3_ROR_25"},
                           {{al, r11, r0, r3, ROR, 1},
                            false,
                            al,
                            "al r11 r0 r3 ROR 1",
                            "al_r11_r0_r3_ROR_1"},
                           {{al, r10, r7, r8, ROR, 14},
                            false,
                            al,
                            "al r10 r7 r8 ROR 14",
                            "al_r10_r7_r8_ROR_14"},
                           {{al, r12, r8, r5, ROR, 17},
                            false,
                            al,
                            "al r12 r8 r5 ROR 17",
                            "al_r12_r8_r5_ROR_17"},
                           {{al, r13, r11, r1, LSL, 26},
                            false,
                            al,
                            "al r13 r11 r1 LSL 26",
                            "al_r13_r11_r1_LSL_26"},
                           {{al, r13, r4, r5, ROR, 26},
                            false,
                            al,
                            "al r13 r4 r5 ROR 26",
                            "al_r13_r4_r5_ROR_26"},
                           {{al, r12, r5, r8, ROR, 17},
                            false,
                            al,
                            "al r12 r5 r8 ROR 17",
                            "al_r12_r5_r8_ROR_17"},
                           {{al, r12, r0, r10, ROR, 16},
                            false,
                            al,
                            "al r12 r0 r10 ROR 16",
                            "al_r12_r0_r10_ROR_16"},
                           {{al, r6, r4, r14, ROR, 28},
                            false,
                            al,
                            "al r6 r4 r14 ROR 28",
                            "al_r6_r4_r14_ROR_28"},
                           {{al, r13, r13, r5, LSL, 16},
                            false,
                            al,
                            "al r13 r13 r5 LSL 16",
                            "al_r13_r13_r5_LSL_16"},
                           {{al, r9, r6, r10, LSL, 15},
                            false,
                            al,
                            "al r9 r6 r10 LSL 15",
                            "al_r9_r6_r10_LSL_15"},
                           {{al, r2, r10, r8, LSL, 16},
                            false,
                            al,
                            "al r2 r10 r8 LSL 16",
                            "al_r2_r10_r8_LSL_16"},
                           {{al, r11, r4, r0, LSL, 5},
                            false,
                            al,
                            "al r11 r4 r0 LSL 5",
                            "al_r11_r4_r0_LSL_5"},
                           {{al, r9, r2, r14, ROR, 31},
                            false,
                            al,
                            "al r9 r2 r14 ROR 31",
                            "al_r9_r2_r14_ROR_31"},
                           {{al, r0, r7, r11, LSL, 25},
                            false,
                            al,
                            "al r0 r7 r11 LSL 25",
                            "al_r0_r7_r11_LSL_25"},
                           {{al, r2, r6, r12, LSL, 8},
                            false,
                            al,
                            "al r2 r6 r12 LSL 8",
                            "al_r2_r6_r12_LSL_8"},
                           {{al, r1, r10, r4, ROR, 7},
                            false,
                            al,
                            "al r1 r10 r4 ROR 7",
                            "al_r1_r10_r4_ROR_7"},
                           {{al, r4, r3, r7, LSL, 10},
                            false,
                            al,
                            "al r4 r3 r7 LSL 10",
                            "al_r4_r3_r7_LSL_10"},
                           {{al, r6, r7, r11, LSL, 14},
                            false,
                            al,
                            "al r6 r7 r11 LSL 14",
                            "al_r6_r7_r11_LSL_14"},
                           {{al, r9, r10, r0, LSL, 31},
                            false,
                            al,
                            "al r9 r10 r0 LSL 31",
                            "al_r9_r10_r0_LSL_31"},
                           {{al, r5, r5, r13, LSL, 2},
                            false,
                            al,
                            "al r5 r5 r13 LSL 2",
                            "al_r5_r5_r13_LSL_2"},
                           {{al, r7, r10, r2, LSL, 26},
                            false,
                            al,
                            "al r7 r10 r2 LSL 26",
                            "al_r7_r10_r2_LSL_26"},
                           {{al, r3, r7, r7, LSL, 29},
                            false,
                            al,
                            "al r3 r7 r7 LSL 29",
                            "al_r3_r7_r7_LSL_29"},
                           {{al, r4, r1, r8, LSL, 18},
                            false,
                            al,
                            "al r4 r1 r8 LSL 18",
                            "al_r4_r1_r8_LSL_18"},
                           {{al, r14, r12, r2, LSL, 29},
                            false,
                            al,
                            "al r14 r12 r2 LSL 29",
                            "al_r14_r12_r2_LSL_29"},
                           {{al, r11, r6, r3, ROR, 8},
                            false,
                            al,
                            "al r11 r6 r3 ROR 8",
                            "al_r11_r6_r3_ROR_8"},
                           {{al, r14, r5, r3, LSL, 7},
                            false,
                            al,
                            "al r14 r5 r3 LSL 7",
                            "al_r14_r5_r3_LSL_7"},
                           {{al, r6, r13, r12, LSL, 2},
                            false,
                            al,
                            "al r6 r13 r12 LSL 2",
                            "al_r6_r13_r12_LSL_2"},
                           {{al, r9, r1, r0, ROR, 13},
                            false,
                            al,
                            "al r9 r1 r0 ROR 13",
                            "al_r9_r1_r0_ROR_13"},
                           {{al, r9, r5, r7, LSL, 16},
                            false,
                            al,
                            "al r9 r5 r7 LSL 16",
                            "al_r9_r5_r7_LSL_16"},
                           {{al, r2, r6, r0, ROR, 27},
                            false,
                            al,
                            "al r2 r6 r0 ROR 27",
                            "al_r2_r6_r0_ROR_27"},
                           {{al, r4, r9, r5, LSL, 19},
                            false,
                            al,
                            "al r4 r9 r5 LSL 19",
                            "al_r4_r9_r5_LSL_19"},
                           {{al, r9, r5, r13, ROR, 26},
                            false,
                            al,
                            "al r9 r5 r13 ROR 26",
                            "al_r9_r5_r13_ROR_26"},
                           {{al, r4, r9, r14, LSL, 25},
                            false,
                            al,
                            "al r4 r9 r14 LSL 25",
                            "al_r4_r9_r14_LSL_25"},
                           {{al, r7, r13, r1, LSL, 22},
                            false,
                            al,
                            "al r7 r13 r1 LSL 22",
                            "al_r7_r13_r1_LSL_22"},
                           {{al, r14, r13, r6, LSL, 25},
                            false,
                            al,
                            "al r14 r13 r6 LSL 25",
                            "al_r14_r13_r6_LSL_25"},
                           {{al, r14, r12, r14, ROR, 1},
                            false,
                            al,
                            "al r14 r12 r14 ROR 1",
                            "al_r14_r12_r14_ROR_1"},
                           {{al, r9, r7, r4, ROR, 28},
                            false,
                            al,
                            "al r9 r7 r4 ROR 28",
                            "al_r9_r7_r4_ROR_28"},
                           {{al, r13, r14, r11, ROR, 4},
                            false,
                            al,
                            "al r13 r14 r11 ROR 4",
                            "al_r13_r14_r11_ROR_4"},
                           {{al, r14, r6, r14, LSL, 22},
                            false,
                            al,
                            "al r14 r6 r14 LSL 22",
                            "al_r14_r6_r14_LSL_22"},
                           {{al, r9, r10, r13, LSL, 27},
                            false,
                            al,
                            "al r9 r10 r13 LSL 27",
                            "al_r9_r10_r13_LSL_27"},
                           {{al, r12, r1, r7, LSL, 17},
                            false,
                            al,
                            "al r12 r1 r7 LSL 17",
                            "al_r12_r1_r7_LSL_17"},
                           {{al, r8, r0, r5, ROR, 6},
                            false,
                            al,
                            "al r8 r0 r5 ROR 6",
                            "al_r8_r0_r5_ROR_6"},
                           {{al, r3, r11, r6, LSL, 6},
                            false,
                            al,
                            "al r3 r11 r6 LSL 6",
                            "al_r3_r11_r6_LSL_6"},
                           {{al, r13, r5, r7, LSL, 23},
                            false,
                            al,
                            "al r13 r5 r7 LSL 23",
                            "al_r13_r5_r7_LSL_23"},
                           {{al, r13, r8, r1, ROR, 20},
                            false,
                            al,
                            "al r13 r8 r1 ROR 20",
                            "al_r13_r8_r1_ROR_20"},
                           {{al, r13, r0, r7, LSL, 10},
                            false,
                            al,
                            "al r13 r0 r7 LSL 10",
                            "al_r13_r0_r7_LSL_10"},
                           {{al, r7, r1, r12, ROR, 17},
                            false,
                            al,
                            "al r7 r1 r12 ROR 17",
                            "al_r7_r1_r12_ROR_17"},
                           {{al, r5, r3, r12, LSL, 12},
                            false,
                            al,
                            "al r5 r3 r12 LSL 12",
                            "al_r5_r3_r12_LSL_12"},
                           {{al, r0, r12, r4, LSL, 6},
                            false,
                            al,
                            "al r0 r12 r4 LSL 6",
                            "al_r0_r12_r4_LSL_6"},
                           {{al, r7, r11, r11, ROR, 8},
                            false,
                            al,
                            "al r7 r11 r11 ROR 8",
                            "al_r7_r11_r11_ROR_8"},
                           {{al, r3, r0, r0, LSL, 17},
                            false,
                            al,
                            "al r3 r0 r0 LSL 17",
                            "al_r3_r0_r0_LSL_17"},
                           {{al, r4, r12, r0, ROR, 2},
                            false,
                            al,
                            "al r4 r12 r0 ROR 2",
                            "al_r4_r12_r0_ROR_2"},
                           {{al, r6, r3, r3, LSL, 25},
                            false,
                            al,
                            "al r6 r3 r3 LSL 25",
                            "al_r6_r3_r3_LSL_25"},
                           {{al, r9, r5, r5, LSL, 9},
                            false,
                            al,
                            "al r9 r5 r5 LSL 9",
                            "al_r9_r5_r5_LSL_9"},
                           {{al, r7, r3, r4, LSL, 20},
                            false,
                            al,
                            "al r7 r3 r4 LSL 20",
                            "al_r7_r3_r4_LSL_20"},
                           {{al, r12, r1, r7, ROR, 6},
                            false,
                            al,
                            "al r12 r1 r7 ROR 6",
                            "al_r12_r1_r7_ROR_6"},
                           {{al, r2, r14, r7, LSL, 23},
                            false,
                            al,
                            "al r2 r14 r7 LSL 23",
                            "al_r2_r14_r7_LSL_23"},
                           {{al, r9, r6, r9, ROR, 22},
                            false,
                            al,
                            "al r9 r6 r9 ROR 22",
                            "al_r9_r6_r9_ROR_22"},
                           {{al, r1, r8, r2, ROR, 11},
                            false,
                            al,
                            "al r1 r8 r2 ROR 11",
                            "al_r1_r8_r2_ROR_11"},
                           {{al, r10, r2, r14, ROR, 15},
                            false,
                            al,
                            "al r10 r2 r14 ROR 15",
                            "al_r10_r2_r14_ROR_15"},
                           {{al, r9, r1, r9, ROR, 27},
                            false,
                            al,
                            "al r9 r1 r9 ROR 27",
                            "al_r9_r1_r9_ROR_27"},
                           {{al, r12, r11, r13, ROR, 30},
                            false,
                            al,
                            "al r12 r11 r13 ROR 30",
                            "al_r12_r11_r13_ROR_30"},
                           {{al, r13, r11, r1, ROR, 5},
                            false,
                            al,
                            "al r13 r11 r1 ROR 5",
                            "al_r13_r11_r1_ROR_5"},
                           {{al, r12, r8, r10, LSL, 24},
                            false,
                            al,
                            "al r12 r8 r10 LSL 24",
                            "al_r12_r8_r10_LSL_24"},
                           {{al, r8, r6, r10, ROR, 19},
                            false,
                            al,
                            "al r8 r6 r10 ROR 19",
                            "al_r8_r6_r10_ROR_19"},
                           {{al, r0, r0, r2, ROR, 26},
                            false,
                            al,
                            "al r0 r0 r2 ROR 26",
                            "al_r0_r0_r2_ROR_26"},
                           {{al, r7, r14, r10, LSL, 28},
                            false,
                            al,
                            "al r7 r14 r10 LSL 28",
                            "al_r7_r14_r10_LSL_28"},
                           {{al, r3, r2, r12, LSL, 12},
                            false,
                            al,
                            "al r3 r2 r12 LSL 12",
                            "al_r3_r2_r12_LSL_12"},
                           {{al, r9, r3, r8, ROR, 29},
                            false,
                            al,
                            "al r9 r3 r8 ROR 29",
                            "al_r9_r3_r8_ROR_29"},
                           {{al, r4, r11, r12, LSL, 14},
                            false,
                            al,
                            "al r4 r11 r12 LSL 14",
                            "al_r4_r11_r12_LSL_14"},
                           {{al, r7, r5, r11, ROR, 9},
                            false,
                            al,
                            "al r7 r5 r11 ROR 9",
                            "al_r7_r5_r11_ROR_9"},
                           {{al, r12, r7, r7, ROR, 2},
                            false,
                            al,
                            "al r12 r7 r7 ROR 2",
                            "al_r12_r7_r7_ROR_2"},
                           {{al, r3, r6, r9, ROR, 24},
                            false,
                            al,
                            "al r3 r6 r9 ROR 24",
                            "al_r3_r6_r9_ROR_24"},
                           {{al, r13, r14, r9, ROR, 12},
                            false,
                            al,
                            "al r13 r14 r9 ROR 12",
                            "al_r13_r14_r9_ROR_12"},
                           {{al, r7, r3, r13, ROR, 2},
                            false,
                            al,
                            "al r7 r3 r13 ROR 2",
                            "al_r7_r3_r13_ROR_2"},
                           {{al, r5, r11, r3, LSL, 21},
                            false,
                            al,
                            "al r5 r11 r3 LSL 21",
                            "al_r5_r11_r3_LSL_21"},
                           {{al, r12, r9, r9, ROR, 17},
                            false,
                            al,
                            "al r12 r9 r9 ROR 17",
                            "al_r12_r9_r9_ROR_17"},
                           {{al, r0, r12, r13, ROR, 3},
                            false,
                            al,
                            "al r0 r12 r13 ROR 3",
                            "al_r0_r12_r13_ROR_3"},
                           {{al, r2, r4, r7, ROR, 28},
                            false,
                            al,
                            "al r2 r4 r7 ROR 28",
                            "al_r2_r4_r7_ROR_28"},
                           {{al, r11, r14, r8, LSL, 5},
                            false,
                            al,
                            "al r11 r14 r8 LSL 5",
                            "al_r11_r14_r8_LSL_5"},
                           {{al, r14, r3, r14, ROR, 11},
                            false,
                            al,
                            "al r14 r3 r14 ROR 11",
                            "al_r14_r3_r14_ROR_11"},
                           {{al, r3, r4, r9, LSL, 10},
                            false,
                            al,
                            "al r3 r4 r9 LSL 10",
                            "al_r3_r4_r9_LSL_10"},
                           {{al, r10, r5, r3, ROR, 11},
                            false,
                            al,
                            "al r10 r5 r3 ROR 11",
                            "al_r10_r5_r3_ROR_11"},
                           {{al, r5, r12, r2, ROR, 29},
                            false,
                            al,
                            "al r5 r12 r2 ROR 29",
                            "al_r5_r12_r2_ROR_29"},
                           {{al, r12, r10, r8, ROR, 29},
                            false,
                            al,
                            "al r12 r10 r8 ROR 29",
                            "al_r12_r10_r8_ROR_29"},
                           {{al, r4, r2, r12, ROR, 13},
                            false,
                            al,
                            "al r4 r2 r12 ROR 13",
                            "al_r4_r2_r12_ROR_13"},
                           {{al, r11, r7, r7, ROR, 29},
                            false,
                            al,
                            "al r11 r7 r7 ROR 29",
                            "al_r11_r7_r7_ROR_29"},
                           {{al, r12, r10, r2, ROR, 20},
                            false,
                            al,
                            "al r12 r10 r2 ROR 20",
                            "al_r12_r10_r2_ROR_20"},
                           {{al, r0, r11, r3, LSL, 6},
                            false,
                            al,
                            "al r0 r11 r3 LSL 6",
                            "al_r0_r11_r3_LSL_6"},
                           {{al, r12, r8, r10, ROR, 13},
                            false,
                            al,
                            "al r12 r8 r10 ROR 13",
                            "al_r12_r8_r10_ROR_13"},
                           {{al, r2, r3, r9, LSL, 30},
                            false,
                            al,
                            "al r2 r3 r9 LSL 30",
                            "al_r2_r3_r9_LSL_30"},
                           {{al, r9, r5, r8, ROR, 27},
                            false,
                            al,
                            "al r9 r5 r8 ROR 27",
                            "al_r9_r5_r8_ROR_27"},
                           {{al, r7, r3, r12, ROR, 16},
                            false,
                            al,
                            "al r7 r3 r12 ROR 16",
                            "al_r7_r3_r12_ROR_16"},
                           {{al, r11, r8, r3, LSL, 29},
                            false,
                            al,
                            "al r11 r8 r3 LSL 29",
                            "al_r11_r8_r3_LSL_29"},
                           {{al, r3, r9, r3, LSL, 13},
                            false,
                            al,
                            "al r3 r9 r3 LSL 13",
                            "al_r3_r9_r3_LSL_13"},
                           {{al, r10, r2, r13, LSL, 7},
                            false,
                            al,
                            "al r10 r2 r13 LSL 7",
                            "al_r10_r2_r13_LSL_7"},
                           {{al, r1, r0, r9, LSL, 22},
                            false,
                            al,
                            "al r1 r0 r9 LSL 22",
                            "al_r1_r0_r9_LSL_22"},
                           {{al, r8, r3, r9, ROR, 24},
                            false,
                            al,
                            "al r8 r3 r9 ROR 24",
                            "al_r8_r3_r9_ROR_24"},
                           {{al, r9, r13, r8, LSL, 25},
                            false,
                            al,
                            "al r9 r13 r8 LSL 25",
                            "al_r9_r13_r8_LSL_25"},
                           {{al, r7, r2, r13, ROR, 16},
                            false,
                            al,
                            "al r7 r2 r13 ROR 16",
                            "al_r7_r2_r13_ROR_16"},
                           {{al, r5, r6, r3, LSL, 3},
                            false,
                            al,
                            "al r5 r6 r3 LSL 3",
                            "al_r5_r6_r3_LSL_3"},
                           {{al, r5, r6, r10, LSL, 15},
                            false,
                            al,
                            "al r5 r6 r10 LSL 15",
                            "al_r5_r6_r10_LSL_15"},
                           {{al, r6, r8, r12, LSL, 13},
                            false,
                            al,
                            "al r6 r8 r12 LSL 13",
                            "al_r6_r8_r12_LSL_13"},
                           {{al, r1, r9, r11, ROR, 7},
                            false,
                            al,
                            "al r1 r9 r11 ROR 7",
                            "al_r1_r9_r11_ROR_7"},
                           {{al, r0, r3, r7, LSL, 12},
                            false,
                            al,
                            "al r0 r3 r7 LSL 12",
                            "al_r0_r3_r7_LSL_12"},
                           {{al, r8, r10, r2, ROR, 6},
                            false,
                            al,
                            "al r8 r10 r2 ROR 6",
                            "al_r8_r10_r2_ROR_6"},
                           {{al, r2, r11, r5, LSL, 10},
                            false,
                            al,
                            "al r2 r11 r5 LSL 10",
                            "al_r2_r11_r5_LSL_10"},
                           {{al, r13, r5, r4, LSL, 15},
                            false,
                            al,
                            "al r13 r5 r4 LSL 15",
                            "al_r13_r5_r4_LSL_15"},
                           {{al, r6, r1, r12, LSL, 27},
                            false,
                            al,
                            "al r6 r1 r12 LSL 27",
                            "al_r6_r1_r12_LSL_27"},
                           {{al, r14, r3, r5, ROR, 19},
                            false,
                            al,
                            "al r14 r3 r5 ROR 19",
                            "al_r14_r3_r5_ROR_19"},
                           {{al, r14, r0, r13, LSL, 12},
                            false,
                            al,
                            "al r14 r0 r13 LSL 12",
                            "al_r14_r0_r13_LSL_12"},
                           {{al, r11, r2, r8, ROR, 15},
                            false,
                            al,
                            "al r11 r2 r8 ROR 15",
                            "al_r11_r2_r8_ROR_15"},
                           {{al, r0, r1, r3, ROR, 1},
                            false,
                            al,
                            "al r0 r1 r3 ROR 1",
                            "al_r0_r1_r3_ROR_1"},
                           {{al, r13, r11, r11, ROR, 31},
                            false,
                            al,
                            "al r13 r11 r11 ROR 31",
                            "al_r13_r11_r11_ROR_31"},
                           {{al, r1, r4, r4, LSL, 20},
                            false,
                            al,
                            "al r1 r4 r4 LSL 20",
                            "al_r1_r4_r4_LSL_20"},
                           {{al, r2, r7, r6, ROR, 7},
                            false,
                            al,
                            "al r2 r7 r6 ROR 7",
                            "al_r2_r7_r6_ROR_7"},
                           {{al, r0, r3, r11, ROR, 21},
                            false,
                            al,
                            "al r0 r3 r11 ROR 21",
                            "al_r0_r3_r11_ROR_21"},
                           {{al, r14, r9, r6, LSL, 20},
                            false,
                            al,
                            "al r14 r9 r6 LSL 20",
                            "al_r14_r9_r6_LSL_20"},
                           {{al, r11, r2, r14, ROR, 1},
                            false,
                            al,
                            "al r11 r2 r14 ROR 1",
                            "al_r11_r2_r14_ROR_1"},
                           {{al, r13, r10, r8, ROR, 22},
                            false,
                            al,
                            "al r13 r10 r8 ROR 22",
                            "al_r13_r10_r8_ROR_22"},
                           {{al, r11, r2, r2, LSL, 27},
                            false,
                            al,
                            "al r11 r2 r2 LSL 27",
                            "al_r11_r2_r2_LSL_27"},
                           {{al, r3, r2, r14, LSL, 6},
                            false,
                            al,
                            "al r3 r2 r14 LSL 6",
                            "al_r3_r2_r14_LSL_6"},
                           {{al, r8, r3, r0, LSL, 20},
                            false,
                            al,
                            "al r8 r3 r0 LSL 20",
                            "al_r8_r3_r0_LSL_20"},
                           {{al, r8, r14, r11, ROR, 19},
                            false,
                            al,
                            "al r8 r14 r11 ROR 19",
                            "al_r8_r14_r11_ROR_19"},
                           {{al, r7, r14, r0, ROR, 8},
                            false,
                            al,
                            "al r7 r14 r0 ROR 8",
                            "al_r7_r14_r0_ROR_8"},
                           {{al, r6, r6, r3, ROR, 13},
                            false,
                            al,
                            "al r6 r6 r3 ROR 13",
                            "al_r6_r6_r3_ROR_13"},
                           {{al, r1, r9, r3, LSL, 10},
                            false,
                            al,
                            "al r1 r9 r3 LSL 10",
                            "al_r1_r9_r3_LSL_10"},
                           {{al, r14, r12, r14, ROR, 13},
                            false,
                            al,
                            "al r14 r12 r14 ROR 13",
                            "al_r14_r12_r14_ROR_13"},
                           {{al, r8, r5, r13, LSL, 19},
                            false,
                            al,
                            "al r8 r5 r13 LSL 19",
                            "al_r8_r5_r13_LSL_19"},
                           {{al, r6, r10, r10, ROR, 3},
                            false,
                            al,
                            "al r6 r10 r10 ROR 3",
                            "al_r6_r10_r10_ROR_3"},
                           {{al, r9, r5, r1, ROR, 19},
                            false,
                            al,
                            "al r9 r5 r1 ROR 19",
                            "al_r9_r5_r1_ROR_19"},
                           {{al, r10, r8, r1, LSL, 12},
                            false,
                            al,
                            "al r10 r8 r1 LSL 12",
                            "al_r10_r8_r1_LSL_12"},
                           {{al, r3, r0, r6, ROR, 31},
                            false,
                            al,
                            "al r3 r0 r6 ROR 31",
                            "al_r3_r0_r6_ROR_31"},
                           {{al, r6, r6, r5, ROR, 1},
                            false,
                            al,
                            "al r6 r6 r5 ROR 1",
                            "al_r6_r6_r5_ROR_1"},
                           {{al, r3, r0, r0, LSL, 18},
                            false,
                            al,
                            "al r3 r0 r0 LSL 18",
                            "al_r3_r0_r0_LSL_18"},
                           {{al, r14, r12, r1, LSL, 11},
                            false,
                            al,
                            "al r14 r12 r1 LSL 11",
                            "al_r14_r12_r1_LSL_11"},
                           {{al, r4, r13, r1, ROR, 17},
                            false,
                            al,
                            "al r4 r13 r1 ROR 17",
                            "al_r4_r13_r1_ROR_17"},
                           {{al, r1, r13, r0, ROR, 10},
                            false,
                            al,
                            "al r1 r13 r0 ROR 10",
                            "al_r1_r13_r0_ROR_10"},
                           {{al, r8, r0, r0, LSL, 11},
                            false,
                            al,
                            "al r8 r0 r0 LSL 11",
                            "al_r8_r0_r0_LSL_11"},
                           {{al, r3, r3, r10, ROR, 18},
                            false,
                            al,
                            "al r3 r3 r10 ROR 18",
                            "al_r3_r3_r10_ROR_18"},
                           {{al, r12, r8, r9, LSL, 7},
                            false,
                            al,
                            "al r12 r8 r9 LSL 7",
                            "al_r12_r8_r9_LSL_7"},
                           {{al, r3, r3, r11, ROR, 10},
                            false,
                            al,
                            "al r3 r3 r11 ROR 10",
                            "al_r3_r3_r11_ROR_10"},
                           {{al, r3, r14, r6, ROR, 5},
                            false,
                            al,
                            "al r3 r14 r6 ROR 5",
                            "al_r3_r14_r6_ROR_5"},
                           {{al, r7, r0, r12, ROR, 7},
                            false,
                            al,
                            "al r7 r0 r12 ROR 7",
                            "al_r7_r0_r12_ROR_7"},
                           {{al, r12, r2, r8, LSL, 13},
                            false,
                            al,
                            "al r12 r2 r8 LSL 13",
                            "al_r12_r2_r8_LSL_13"},
                           {{al, r10, r1, r0, ROR, 8},
                            false,
                            al,
                            "al r10 r1 r0 ROR 8",
                            "al_r10_r1_r0_ROR_8"},
                           {{al, r6, r12, r6, LSL, 30},
                            false,
                            al,
                            "al r6 r12 r6 LSL 30",
                            "al_r6_r12_r6_LSL_30"},
                           {{al, r6, r3, r7, ROR, 11},
                            false,
                            al,
                            "al r6 r3 r7 ROR 11",
                            "al_r6_r3_r7_ROR_11"},
                           {{al, r5, r12, r7, ROR, 28},
                            false,
                            al,
                            "al r5 r12 r7 ROR 28",
                            "al_r5_r12_r7_ROR_28"},
                           {{al, r4, r12, r10, LSL, 6},
                            false,
                            al,
                            "al r4 r12 r10 LSL 6",
                            "al_r4_r12_r10_LSL_6"},
                           {{al, r11, r5, r1, ROR, 3},
                            false,
                            al,
                            "al r11 r5 r1 ROR 3",
                            "al_r11_r5_r1_ROR_3"},
                           {{al, r9, r3, r0, ROR, 26},
                            false,
                            al,
                            "al r9 r3 r0 ROR 26",
                            "al_r9_r3_r0_ROR_26"},
                           {{al, r8, r1, r10, LSL, 13},
                            false,
                            al,
                            "al r8 r1 r10 LSL 13",
                            "al_r8_r1_r10_LSL_13"},
                           {{al, r14, r13, r14, ROR, 20},
                            false,
                            al,
                            "al r14 r13 r14 ROR 20",
                            "al_r14_r13_r14_ROR_20"},
                           {{al, r2, r3, r8, LSL, 7},
                            false,
                            al,
                            "al r2 r3 r8 LSL 7",
                            "al_r2_r3_r8_LSL_7"},
                           {{al, r0, r11, r10, ROR, 4},
                            false,
                            al,
                            "al r0 r11 r10 ROR 4",
                            "al_r0_r11_r10_ROR_4"},
                           {{al, r1, r6, r9, LSL, 27},
                            false,
                            al,
                            "al r1 r6 r9 LSL 27",
                            "al_r1_r6_r9_LSL_27"},
                           {{al, r5, r2, r4, ROR, 10},
                            false,
                            al,
                            "al r5 r2 r4 ROR 10",
                            "al_r5_r2_r4_ROR_10"},
                           {{al, r13, r8, r9, LSL, 20},
                            false,
                            al,
                            "al r13 r8 r9 LSL 20",
                            "al_r13_r8_r9_LSL_20"},
                           {{al, r11, r7, r0, LSL, 20},
                            false,
                            al,
                            "al r11 r7 r0 LSL 20",
                            "al_r11_r7_r0_LSL_20"},
                           {{al, r2, r9, r1, LSL, 30},
                            false,
                            al,
                            "al r2 r9 r1 LSL 30",
                            "al_r2_r9_r1_LSL_30"},
                           {{al, r5, r0, r5, ROR, 24},
                            false,
                            al,
                            "al r5 r0 r5 ROR 24",
                            "al_r5_r0_r5_ROR_24"},
                           {{al, r7, r4, r10, LSL, 17},
                            false,
                            al,
                            "al r7 r4 r10 LSL 17",
                            "al_r7_r4_r10_LSL_17"},
                           {{al, r11, r3, r7, ROR, 19},
                            false,
                            al,
                            "al r11 r3 r7 ROR 19",
                            "al_r11_r3_r7_ROR_19"},
                           {{al, r8, r2, r6, ROR, 1},
                            false,
                            al,
                            "al r8 r2 r6 ROR 1",
                            "al_r8_r2_r6_ROR_1"},
                           {{al, r5, r1, r8, ROR, 25},
                            false,
                            al,
                            "al r5 r1 r8 ROR 25",
                            "al_r5_r1_r8_ROR_25"},
                           {{al, r1, r4, r12, LSL, 28},
                            false,
                            al,
                            "al r1 r4 r12 LSL 28",
                            "al_r1_r4_r12_LSL_28"},
                           {{al, r12, r1, r4, LSL, 14},
                            false,
                            al,
                            "al r12 r1 r4 LSL 14",
                            "al_r12_r1_r4_LSL_14"},
                           {{al, r9, r12, r13, LSL, 25},
                            false,
                            al,
                            "al r9 r12 r13 LSL 25",
                            "al_r9_r12_r13_LSL_25"},
                           {{al, r11, r14, r5, ROR, 12},
                            false,
                            al,
                            "al r11 r14 r5 ROR 12",
                            "al_r11_r14_r5_ROR_12"},
                           {{al, r3, r8, r13, LSL, 4},
                            false,
                            al,
                            "al r3 r8 r13 LSL 4",
                            "al_r3_r8_r13_LSL_4"},
                           {{al, r9, r14, r10, ROR, 12},
                            false,
                            al,
                            "al r9 r14 r10 ROR 12",
                            "al_r9_r14_r10_ROR_12"},
                           {{al, r0, r13, r1, ROR, 30},
                            false,
                            al,
                            "al r0 r13 r1 ROR 30",
                            "al_r0_r13_r1_ROR_30"},
                           {{al, r11, r9, r9, ROR, 23},
                            false,
                            al,
                            "al r11 r9 r9 ROR 23",
                            "al_r11_r9_r9_ROR_23"},
                           {{al, r5, r2, r8, ROR, 6},
                            false,
                            al,
                            "al r5 r2 r8 ROR 6",
                            "al_r5_r2_r8_ROR_6"},
                           {{al, r8, r14, r10, ROR, 23},
                            false,
                            al,
                            "al r8 r14 r10 ROR 23",
                            "al_r8_r14_r10_ROR_23"},
                           {{al, r14, r12, r2, LSL, 26},
                            false,
                            al,
                            "al r14 r12 r2 LSL 26",
                            "al_r14_r12_r2_LSL_26"},
                           {{al, r2, r9, r10, LSL, 12},
                            false,
                            al,
                            "al r2 r9 r10 LSL 12",
                            "al_r2_r9_r10_LSL_12"},
                           {{al, r3, r1, r11, LSL, 17},
                            false,
                            al,
                            "al r3 r1 r11 LSL 17",
                            "al_r3_r1_r11_LSL_17"},
                           {{al, r3, r8, r10, LSL, 23},
                            false,
                            al,
                            "al r3 r8 r10 LSL 23",
                            "al_r3_r8_r10_LSL_23"},
                           {{al, r3, r6, r4, ROR, 31},
                            false,
                            al,
                            "al r3 r6 r4 ROR 31",
                            "al_r3_r6_r4_ROR_31"},
                           {{al, r3, r5, r10, LSL, 22},
                            false,
                            al,
                            "al r3 r5 r10 LSL 22",
                            "al_r3_r5_r10_LSL_22"},
                           {{al, r0, r3, r10, ROR, 1},
                            false,
                            al,
                            "al r0 r3 r10 ROR 1",
                            "al_r0_r3_r10_ROR_1"},
                           {{al, r5, r9, r7, ROR, 9},
                            false,
                            al,
                            "al r5 r9 r7 ROR 9",
                            "al_r5_r9_r7_ROR_9"},
                           {{al, r11, r2, r2, LSL, 24},
                            false,
                            al,
                            "al r11 r2 r2 LSL 24",
                            "al_r11_r2_r2_LSL_24"},
                           {{al, r10, r11, r7, LSL, 29},
                            false,
                            al,
                            "al r10 r11 r7 LSL 29",
                            "al_r10_r11_r7_LSL_29"},
                           {{al, r5, r4, r10, ROR, 26},
                            false,
                            al,
                            "al r5 r4 r10 ROR 26",
                            "al_r5_r4_r10_ROR_26"},
                           {{al, r8, r8, r7, LSL, 20},
                            false,
                            al,
                            "al r8 r8 r7 LSL 20",
                            "al_r8_r8_r7_LSL_20"},
                           {{al, r12, r6, r5, ROR, 20},
                            false,
                            al,
                            "al r12 r6 r5 ROR 20",
                            "al_r12_r6_r5_ROR_20"},
                           {{al, r9, r4, r7, LSL, 21},
                            false,
                            al,
                            "al r9 r4 r7 LSL 21",
                            "al_r9_r4_r7_LSL_21"},
                           {{al, r8, r2, r7, LSL, 4},
                            false,
                            al,
                            "al r8 r2 r7 LSL 4",
                            "al_r8_r2_r7_LSL_4"},
                           {{al, r9, r14, r12, LSL, 8},
                            false,
                            al,
                            "al r9 r14 r12 LSL 8",
                            "al_r9_r14_r12_LSL_8"},
                           {{al, r1, r12, r8, ROR, 25},
                            false,
                            al,
                            "al r1 r12 r8 ROR 25",
                            "al_r1_r12_r8_ROR_25"},
                           {{al, r4, r1, r4, ROR, 26},
                            false,
                            al,
                            "al r4 r1 r4 ROR 26",
                            "al_r4_r1_r4_ROR_26"},
                           {{al, r12, r6, r14, ROR, 22},
                            false,
                            al,
                            "al r12 r6 r14 ROR 22",
                            "al_r12_r6_r14_ROR_22"},
                           {{al, r2, r6, r9, LSL, 17},
                            false,
                            al,
                            "al r2 r6 r9 LSL 17",
                            "al_r2_r6_r9_LSL_17"},
                           {{al, r8, r8, r1, ROR, 15},
                            false,
                            al,
                            "al r8 r8 r1 ROR 15",
                            "al_r8_r8_r1_ROR_15"},
                           {{al, r13, r10, r8, ROR, 27},
                            false,
                            al,
                            "al r13 r10 r8 ROR 27",
                            "al_r13_r10_r8_ROR_27"},
                           {{al, r1, r10, r10, LSL, 27},
                            false,
                            al,
                            "al r1 r10 r10 LSL 27",
                            "al_r1_r10_r10_LSL_27"},
                           {{al, r7, r1, r11, ROR, 26},
                            false,
                            al,
                            "al r7 r1 r11 ROR 26",
                            "al_r7_r1_r11_ROR_26"},
                           {{al, r13, r14, r11, ROR, 29},
                            false,
                            al,
                            "al r13 r14 r11 ROR 29",
                            "al_r13_r14_r11_ROR_29"},
                           {{al, r5, r3, r14, ROR, 7},
                            false,
                            al,
                            "al r5 r3 r14 ROR 7",
                            "al_r5_r3_r14_ROR_7"},
                           {{al, r2, r12, r9, LSL, 22},
                            false,
                            al,
                            "al r2 r12 r9 LSL 22",
                            "al_r2_r12_r9_LSL_22"},
                           {{al, r4, r2, r9, LSL, 12},
                            false,
                            al,
                            "al r4 r2 r9 LSL 12",
                            "al_r4_r2_r9_LSL_12"},
                           {{al, r6, r7, r5, LSL, 8},
                            false,
                            al,
                            "al r6 r7 r5 LSL 8",
                            "al_r6_r7_r5_LSL_8"},
                           {{al, r14, r11, r6, LSL, 10},
                            false,
                            al,
                            "al r14 r11 r6 LSL 10",
                            "al_r14_r11_r6_LSL_10"},
                           {{al, r11, r10, r7, ROR, 10},
                            false,
                            al,
                            "al r11 r10 r7 ROR 10",
                            "al_r11_r10_r7_ROR_10"},
                           {{al, r9, r11, r5, ROR, 8},
                            false,
                            al,
                            "al r9 r11 r5 ROR 8",
                            "al_r9_r11_r5_ROR_8"},
                           {{al, r13, r12, r0, ROR, 1},
                            false,
                            al,
                            "al r13 r12 r0 ROR 1",
                            "al_r13_r12_r0_ROR_1"},
                           {{al, r7, r9, r3, ROR, 1},
                            false,
                            al,
                            "al r7 r9 r3 ROR 1",
                            "al_r7_r9_r3_ROR_1"},
                           {{al, r10, r2, r13, LSL, 17},
                            false,
                            al,
                            "al r10 r2 r13 LSL 17",
                            "al_r10_r2_r13_LSL_17"},
                           {{al, r10, r6, r6, LSL, 16},
                            false,
                            al,
                            "al r10 r6 r6 LSL 16",
                            "al_r10_r6_r6_LSL_16"},
                           {{al, r5, r8, r9, ROR, 25},
                            false,
                            al,
                            "al r5 r8 r9 ROR 25",
                            "al_r5_r8_r9_ROR_25"},
                           {{al, r14, r13, r2, LSL, 23},
                            false,
                            al,
                            "al r14 r13 r2 LSL 23",
                            "al_r14_r13_r2_LSL_23"},
                           {{al, r5, r13, r6, ROR, 13},
                            false,
                            al,
                            "al r5 r13 r6 ROR 13",
                            "al_r5_r13_r6_ROR_13"},
                           {{al, r6, r14, r5, LSL, 3},
                            false,
                            al,
                            "al r6 r14 r5 LSL 3",
                            "al_r6_r14_r5_LSL_3"},
                           {{al, r11, r8, r14, ROR, 2},
                            false,
                            al,
                            "al r11 r8 r14 ROR 2",
                            "al_r11_r8_r14_ROR_2"},
                           {{al, r3, r11, r13, ROR, 25},
                            false,
                            al,
                            "al r3 r11 r13 ROR 25",
                            "al_r3_r11_r13_ROR_25"},
                           {{al, r2, r1, r6, LSL, 3},
                            false,
                            al,
                            "al r2 r1 r6 LSL 3",
                            "al_r2_r1_r6_LSL_3"},
                           {{al, r1, r7, r3, ROR, 30},
                            false,
                            al,
                            "al r1 r7 r3 ROR 30",
                            "al_r1_r7_r3_ROR_30"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adc-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adcs-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-add-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-adds-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-and-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-ands-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-bic-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-bics-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-eor-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-eors-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orn-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orns-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orr-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-orrs-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rsb-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-rsbs-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sbc-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sbcs-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-sub-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-rm-shift-amount-1to31-subs-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    Operand op(rm, shift, amount);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                        \
  void Test_##mnemonic() {                                                    \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);   \
  }                                                                           \
  Test test_##mnemonic(                                                       \
      "AARCH32_ASSEMBLER_COND_RD_RN_OPERAND_RM_SHIFT_AMOUNT_1TO31_" #mnemonic \
      "_T32",                                                                 \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
