
// vbts.cpp
// executable for time series data manipulation
// Copyright (c) 2003 by The VoxBo Development Team

// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// code contributed by Tom King
// code contributed by Dan Kimberg

#include <stdio.h>
#include <string>
#include <vector>
#include <fstream>
#include "vbprefs.h"
#include "vbutil.h"
#include "vbio.h"
#include "vbjobspec.h"
#include "vbts.hlp.h"

void vbts_version();
void vbts_help();
int tmpeq(VB_Vector &a,VB_Vector &b);

using namespace std;

// VBPrefs vbp;

int
main(int argc, char **argv)
{
  tokenlist args;
  args.Transfer(argc-1,argv+1);
  if (args.size()!=1) {
    vbts_help();
    exit(0);
  }

  string infile=args[0];
  Tes tes;
  if (tes.ReadFile(infile)) {
    printf("[E] vbts: couldn't read input file %s\n",infile.c_str());
    exit(101);
  }
  int empties=0;
  int oobs=0;
  int used=0;
  int i,j,k,m,match,index;
  vector<VB_Vector> patterns;
  for (i=0; i<tes.dimx; i++) {
    cout << patterns.size() << endl;
    for (j=0; j<tes.dimy; j++) {
      for (k=0; k<tes.dimz; k++) {
	index=tes.voxelposition(i,j,k);
	if (tes.data[index]==NULL) {
	  empties++;
	  continue;
	}
        if (tes.GetTimeSeries(i,j,k)) {
	  oobs++;
          continue;
	}
	match=0;
	for (m=0; m<(int)patterns.size(); m++) {
// 	  if (tmpeq(tes.timeseries,patterns[m]) && !(tes.timeseries==patterns[m])) {
// 	    tes.timeseries.print();
// 	    patterns[m].print();
// 	    abort();
// 	  }
	  //if (tes.timeseries==patterns[m]) {
	  if (tmpeq(tes.timeseries,patterns[m])) {
	    match=1;
	    break;
	  }
	}
	used++;
	if (match==0)
	  patterns.push_back(tes.timeseries);	
      }
    }
  }
  printf("[I] vbts: expected %ld voxels\n",(long)tes.dimx*tes.dimy*tes.dimz);
  printf("[I] vbts: found %ld voxels\n",(long)empties+used);
  printf("[I] vbts: found %d OOB (should be zero)\n",oobs);
  printf("[I] vbts: found %d unique time series patterns\n",(int)patterns.size());
  exit(0);
}

int
tmpeq(VB_Vector &a,VB_Vector &b)
{
  if (a.size()!=b.size())
    return 0;
  for (int i=0; i<a.size(); i++) {
    if (a[i]!=b[i])
      return 0;
  }
  return 1;
}

void
vbts_help()
{
  cout << boost::format(myhelp) % vbversion;
}

void
vbts_version()
{
  printf("VoxBo vbts (v%s)\n",vbversion.c_str());
}
