
// idlfree.cpp
// Hack to check number of IDL license
// Copyright (c) 1998-2001 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg
// <kimberg@mail.med.upenn.edu>.

using namespace std;

#include "voxbo.h"

const char *lmstat="/usr/local/rsi/idl/bin/lmstat -f idl";

int
main()
{
  FILE *fp;
  char buf[STRINGLEN];
  int inuse,licensecount,cnt,inidl;
  tokenlist args;
  
  fp = popen(lmstat,"r");
  if (!fp)
    return (FALSE);

  licensecount=inuse=0;
  inidl=FALSE;
  while(fgets(buf,STRINGLEN,fp)) {
    args.SetSeparator(" \t\n,:;[]{}()\"'");
    args.ParseLine(buf);
    if (args.size() < 8)
      continue;
    if (args[0]=="Users" && args[2]=="idl" && args[6]=="licenses") {
      licensecount = strtol(args[5].c_str(),NULL,10);
      inidl = TRUE;
    }
    else if (args[0]=="Users")
      inidl = FALSE;
    else if (inidl == TRUE) {
      if (args[args.size()-1]!="licenses")
	continue;
      cnt = strtol(args[args.size()-2]);
      if (cnt > 0)
	inuse += cnt;
    }
  }
  pclose(fp);
  // the following line is just for show
  printf("found %d licenses\n",(licensecount - inuse));
  exit((licensecount - inuse));
}
