
// vbsubmit.cpp
// code to submit jobs (warning: usually run setuid)
// Copyright (c) 1998-2008 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

using namespace std;

#include "voxbo.h"

VBPrefs vbp;

uid_t euid;

int
main(int argc,char *argv[])
{
  euid = geteuid();     // save the effective userid
  seteuid(getuid());    // set to the actual user running the code
  signal(SIGHUP,SIG_IGN);
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  signal(SIGILL,SIG_IGN);
  signal(SIGTRAP,SIG_IGN);
  signal(SIGABRT,SIG_IGN);
  signal(SIGFPE,SIG_IGN);
  signal(SIGBUS,SIG_IGN);
  signal(SIGSEGV,SIG_IGN);
  signal(SIGPIPE,SIG_IGN);
  signal(SIGALRM,SIG_IGN);
  signal(SIGTERM,SIG_IGN);
  signal(SIGUSR1,SIG_IGN);
  signal(SIGUSR2,SIG_IGN);
  signal(SIGTSTP,SIG_IGN);
  signal(SIGTTIN,SIG_IGN);
  signal(SIGTTOU,SIG_IGN);
  signal(SIGVTALRM,SIG_IGN);
  signal(SIGPROF,SIG_IGN);
  signal(SIGXCPU,SIG_IGN);
  signal(SIGXFSZ,SIG_IGN);
  signal(SIGCHLD,SIG_IGN);
  signal(SIGCONT,SIG_IGN);
  signal(SIGURG,SIG_IGN);
  signal(SIGWINCH,SIG_IGN);
#ifdef LINUX
  signal(SIGPOLL,SIG_IGN); 
  signal(SIGIOT,SIG_IGN);
  signal(SIGPWR,SIG_IGN);
#endif

  // set umask so that any created files are not world-writeable
  umask(022);
  if (argc < 2) exit(100);

  FILE *numfile;
  int seqnum;
  char tmp[STRINGLEN],sname[STRINGLEN];
  struct passwd *pwent;

  seteuid(euid);
  vbp.init();
  sprintf(tmp,"%s/vb.num",vbp.queuelist[0].dir.c_str());
//   if (!(access(tmp,R_OK))) {
//     numfile=fopen(tmp,"w");
//     if (!numfile)
//       exit(110);
//     fprintf(numfile,"101\n");
//     fclose(numfile);
//   }
  numfile = fopen(tmp,"r+");
  if (!numfile)        // we're seteuid(), so just exit
    exit(101);
  lockfile(numfile,F_WRLCK);

  if (fgets(tmp,STRINGLEN,numfile) == NULL)
    exit(102);

  seqnum = strtol(tmp,NULL,10);
  rewind(numfile);
  fprintf(numfile,"%d\n",seqnum+1);
  unlockfile(numfile);
  fclose(numfile);
  seteuid(getuid());

  pwent = getpwuid(getuid());
  sprintf(sname,"%s/%08d",vbp.queuelist[0].dir.c_str(),seqnum);

  seteuid(euid);
  VBSequence seq;
  seq.LoadSequence(argv[1]);
  if (!seq.valid)
    exit(103);
  seq.seqnum=seqnum;
  seq.uid=pwent->pw_uid;
  seq.queuedtime=time(NULL);
  seq.owner=pwent->pw_name;
  if (!seq.email[0])
    seq.email="nobody@nowhere.com";seq.owner.c_str();
  int err=seq.Write(sname);
  seteuid(getuid());
  if (!err)
    ;// delete_sequencedir(argv[1]);
  exit(0);
}
