
// vbsubmit_private.cpp
// code to submit jobs to private queue only
// Copyright (c) 1998-2006 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

using namespace std;

#include "voxbo.h"

VBPrefs vbp;

uid_t euid;

int
main(int argc,char *argv[])
{
  if (argc < 2) exit(200);

  FILE *numfile;
  int seqnum;
  char tmp[STRINGLEN],sname[STRINGLEN];
  struct passwd *pwent;

  vbp.init();
  sprintf(tmp,"%s/vb.num",vbp.queuelist[0].dir.c_str());
  if (access(tmp,R_OK)) {
    numfile=fopen(tmp,"w");
    if (!numfile)
      exit(210);
    fprintf(numfile,"101\n");
    fclose(numfile);
  }
  numfile = fopen(tmp,"r+");
  if (!numfile)
    exit(201);
  lockfile(numfile,F_WRLCK);

  if (fgets(tmp,STRINGLEN,numfile) == NULL)
    exit(202);

  seqnum = strtol(tmp,NULL,10);
  rewind(numfile);
  fprintf(numfile,"%d\n",seqnum+1);
  unlockfile(numfile);
  fclose(numfile);

  pwent = getpwuid(getuid());
  sprintf(sname,"%s/%08d",vbp.queuelist[0].dir.c_str(),seqnum);

  VBSequence seq;
  seq.LoadSequence(argv[1]);
  if (!seq.valid)
    exit(203);
  seq.seqnum=seqnum;
  seq.uid=pwent->pw_uid;
  seq.queuedtime=time(NULL);
  seq.owner=pwent->pw_name;
  if (!seq.email[0])
    seq.email="nobody@nowhere.com";
  int err=seq.Write(sname);
  if (!err)
    ;// delete_sequencedir(argv[1]);
  exit(0);
}
