#!/bin/sh

# create data


#vbsim -d 64 64 45 100 -z 2 2 2 2000 -n 0 4 0 -o big1.tes
#vbsim -d 64 64 45 100 -z 2 2 2 2000 -n 0 4 0 -o big2.tes
#vbsim -d 64 64 45 100 -z 2 2 2 2000 -n 0 4 0 -o big3.tes
vbsim -d 12 12 4 20 -z 2 2 2 2000 -n 0 4 0 -o small1.tes
vbsim -d 12 12 4 20 -z 2 2 2 2000 -n 0 4 0 -o small2.tes
vbsim -d 12 12 4 20 -z 2 2 2 2000 -n 0 4 0 -o small3.tes

cat > test.glm<< EOF
pieces 20
audit yes
email nobody@nowhere.com

glm big_glm1
  dirname bigglm1
  gmatrix big.G
  # kernel
  # noisemodel
  meannorm no
  driftcorrect yes
  highs 1
  lows 4
  orderg 60
  scan small1.tes
  scan small2.tes
  scan small3.tes
end
EOF


cat > test.gds<< EOF
gsession big.G

scan xsmall1 20
scan xsmall2 20
scan xsmall3 20

TR 2000
sampling 100
length 60

newcov intercept
 type I
end

newcov spike
 cov-name spikes
 absolute 2,12-14,35,37,52
 option convolve eigen1.ref 2000 " [c]"
end

mean-center-all

EOF

cat > eigen1.ref<< EOF
;VB98
;REF1
      0.00000
     0.356963
     0.904650
     0.908452
     0.440000
    0.0981926
   -0.0208208
   -0.0397777
EOF
