
// vbscale.cpp
// non-gui qt application to generate a color scale png
// Copyright (c) 2009 by The VoxBo Development Team

// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

using namespace std;

#include <QApplication>
#include <QFont>
#include <QImage>
#include <QPainter>
#include <QRect>
#include <QFontMetrics>
#include "stdio.h"
#include "vbutil.h"
#include <iostream>

void drawcolorbars(QPainter *paint,QRect myrect,int fontsize);
void shaderect(QPainter *paint,QRect &r,QColor &c1,QColor &c2);

float q_low;
float q_high;
int fontsize;
int f_vertical;
int q_width,q_height;
QColor q_negcolor1(0,0,100);
QColor q_negcolor2(0,0,200);
QColor q_poscolor1(255,0,0);
QColor q_poscolor2(255,255,0);
QRect posrect,negrect;

int
main(int argc,char **argv)
{
  string outfile;
  // args are: low high pos1 pos2 neg1 neg2 width height fontsize filename
  if (argc==19) {
    q_low=strtod(argv[1]);
    q_high=strtod(argv[2]);
    q_negcolor1=QColor(strtol(argv[3]),strtol(argv[4]),strtol(argv[5]));
    q_negcolor2=QColor(strtol(argv[6]),strtol(argv[7]),strtol(argv[8]));
    q_poscolor1=QColor(strtol(argv[9]),strtol(argv[10]),strtol(argv[11]));
    q_poscolor2=QColor(strtol(argv[12]),strtol(argv[13]),strtol(argv[14]));
    q_width=strtol(argv[15]);
    q_height=strtol(argv[16]);
    fontsize=strtol(argv[17]);
    outfile=argv[18];
  }
  else if (argc==13) {
    q_low=strtod(argv[1]);
    q_high=strtod(argv[2]);
    q_poscolor1=QColor(strtol(argv[3]),strtol(argv[4]),strtol(argv[5]));
    q_poscolor2=QColor(strtol(argv[6]),strtol(argv[7]),strtol(argv[8]));
    q_width=strtol(argv[9]);
    q_height=strtol(argv[10]);
    fontsize=strtol(argv[11]);
    outfile=argv[12];
    q_negcolor1.setAlpha(0);
  }
  else {
    cout << "Argh!" << endl;
    exit(10);
  }


  QApplication a(argc,argv);
  QImage im(q_width,q_height,QImage::Format_RGB888);
  QPainter pp(&im);

  drawcolorbars(&pp,QRect(0,0,q_width,q_height),fontsize);
  pp.end();
  im.save(outfile.c_str());
}




void
drawcolorbars(QPainter *paint,QRect myrect,int fontsize)
{
  f_vertical=0;
  if (myrect.height() > myrect.width()) f_vertical=1;
  paint->setPen(QColor(0,0,0));
  paint->setBackgroundColor(QColor(255,255,255));
  paint->eraseRect(myrect);
  QFont ff("Helvetica");
  ff.setPixelSize(fontsize);
  paint->setFont(ff);
  const int fontwidth=QFontMetrics(ff).width("9.9999");
  const int ISPACE=QFontMetrics(ff).width("i");

  bool f_neg=q_negcolor1.alpha();

  char tmp[64];
  int xoff=myrect.left();
  int yoff=myrect.top();
  const int SPACE=fontsize/2;

  if (f_vertical && f_neg) {
    int barsize=(myrect.height()-SPACE-SPACE-SPACE)/2;
    posrect.setRect(xoff+SPACE,yoff+SPACE,myrect.width()-SPACE-fontwidth,barsize);
    negrect.setRect(xoff+SPACE,yoff+SPACE+barsize+SPACE,myrect.width()-SPACE-fontwidth,barsize);
  }
  else if (f_vertical && !f_neg) {
    int barsize=myrect.height()-SPACE-SPACE;
    posrect.setRect(xoff+SPACE,yoff+SPACE,myrect.width()-SPACE-fontwidth,barsize);
  }
  if (!f_vertical && f_neg) {
    int barsize=(myrect.width()-SPACE-SPACE-SPACE)/2;
    negrect.setRect(xoff+SPACE,yoff+SPACE,barsize,myrect.height()-SPACE-fontsize);
    posrect.setRect(xoff+SPACE+barsize+SPACE,yoff+SPACE,barsize,myrect.height()-SPACE-fontsize);
  }
  if (!f_vertical && !f_neg) {
    int barsize=myrect.width()-SPACE-SPACE;
    posrect.setRect(xoff+SPACE,yoff+SPACE,barsize,myrect.height()-SPACE-fontsize);
  }

  // black rect that will eventually leave just the hairline
  paint->fillRect(posrect,QColor(0,0,0));
  if (f_neg) paint->fillRect(negrect,QColor(0,0,0));

  // now the colors and labels
  if (f_neg && f_vertical) {
    shaderect(paint,negrect,q_negcolor1,q_negcolor2);
    paint->setPen(QColor(0,0,0));
    sprintf(tmp,"%g",q_high*-1); 
    paint->drawText(negrect.right()+ISPACE,negrect.top(),myrect.width()-negrect.right(),negrect.height(),Qt::AlignLeft|Qt::AlignBottom,QString(tmp));
    sprintf(tmp,"%g",q_low*-1);
    paint->drawText(negrect.right()+ISPACE,negrect.top(),myrect.width()-negrect.right(),negrect.height(),Qt::AlignLeft|Qt::AlignTop,QString(tmp));
  }
  else if (f_neg && !f_vertical) {
    shaderect(paint,negrect,q_negcolor2,q_negcolor1);
    paint->setPen(QColor(0,0,0));
    sprintf(tmp,"%g",q_high*-1);
    paint->drawText(negrect.left(),negrect.bottom(),negrect.width(),myrect.height()-negrect.bottom(),Qt::AlignLeft|Qt::AlignTop,QString(tmp));
    sprintf(tmp,"%g",q_low*-1);
    paint->drawText(negrect.left(),negrect.bottom(),negrect.width(),myrect.height()-negrect.bottom(),Qt::AlignRight|Qt::AlignTop,QString(tmp));
  }
  // NOW THE POSITIVE BAR
  if (f_vertical) {
    shaderect(paint,posrect,q_poscolor2,q_poscolor1);
    paint->setPen(QColor(0,0,0));
    sprintf(tmp,"%g",q_low);
    paint->drawText(posrect.right()+ISPACE,posrect.top(),myrect.width()-posrect.right(),posrect.height(),Qt::AlignLeft|Qt::AlignBottom,QString(tmp));
    sprintf(tmp,"%g",q_high);
    paint->drawText(posrect.right()+ISPACE,posrect.top(),myrect.width()-posrect.right(),posrect.height(),Qt::AlignLeft|Qt::AlignTop,QString(tmp));
  }
  else {
    shaderect(paint,posrect,q_poscolor1,q_poscolor2);
    paint->setPen(QColor(0,0,0));
    sprintf(tmp,"%g",q_low);
    paint->drawText(posrect.left(),posrect.bottom(),posrect.width(),myrect.height()-posrect.bottom(),Qt::AlignLeft|Qt::AlignTop,QString(tmp));
    sprintf(tmp,"%g",q_high);
    paint->drawText(posrect.left(),posrect.bottom(),posrect.width(),myrect.height()-posrect.bottom(),Qt::AlignRight|Qt::AlignTop,QString(tmp));
  }
}

void
shaderect(QPainter *paint,QRect &r,QColor &c1,QColor &c2)
{
  int rr,gg,bb;
  float pct;
  // if it's horizontal, we go left to right, vertical we go top to bottom
  if (f_vertical) {
    for (int i=r.top()+1; i<r.bottom(); i++) {
      pct=(float)(i-(r.top()+1))/((r.bottom()-1)-(r.top()+1.0));
      rr=c1.red()+(int)(pct*(c2.red()-c1.red()));
      gg=c1.green()+(int)(pct*(c2.green()-c1.green()));
      bb=c1.blue()+(int)(pct*(c2.blue()-c1.blue()));
      paint->setPen(QColor(rr,gg,bb));
      paint->drawLine(r.left()+1,i,r.right()-1,i);
    }
  }
  else {
    for (int i=r.left()+1; i<r.right(); i++) {
      pct=(float)(i-(r.left()+1))/((r.right()-1)-(r.left()+1));
      rr=c1.red()+(int)(pct*(c2.red()-c1.red()));
      gg=c1.green()+(int)(pct*(c2.green()-c1.green()));
      bb=c1.blue()+(int)(pct*(c2.blue()-c1.blue()));
      paint->setPen(QColor(rr,gg,bb));
      paint->drawLine(i,r.top()+1,i,r.bottom()-1);
    }
  }
}
