/*---------------------------------------------------------------------------*\

	Scoped mutex sentinel.

         Copyright (C) 2004 - 2007 Ron Lee, Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License version 2.1 as published by the Free Software Foundation;

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __SCOPEDMUTED_H__
#define __SCOPEDMUTED_H__

#include <pthread.h>


//! Simple exception safe mutex sentinel.
//
//! @warning This does not, and cannot protect against thread cancellation.
//!          It should not be used in such contexts if the mutex held will
//!          outlive the thread being cancelled.
class ScopedMutex
{ //{{{
private:

	pthread_mutex_t    *m_mutex;


public:

	//! Lock @a mutex for the lifetime of this object.
	ScopedMutex( pthread_mutex_t *mutex )
	    : m_mutex( mutex )
	{
		pthread_mutex_lock( m_mutex );
	}

	//! Unlock the mutex again.
	~ScopedMutex()
	{
		pthread_mutex_unlock( m_mutex );
	}

}; //}}}


#endif	// __SCOPEDMUTED_H__

