/*---------------------------------------------------------------------------*\

	FUNCTION....: window()

	AUTHOR......: John Kostogiannis
	DATE CREATED: 26/6/96

	windows a Nsam vector of speech samples.

\*---------------------------------------------------------------------------*/

#include "wind.h"

void window(int Wn[], int sn[], int Nsam, int window_table[],int nrsh)
/*  int	 Wn[];			output frame of windowed samples	*/
/*  int  sn[];			input frame of speech samples		*/
/*  int	 Nsam;			number of samples			*/
/*  int	 window_table[];	LOOK-UP TABLE				*/
/*  int  nrsh;			number of right shifts	(only)		*/
{
    int i;    /* loop variable */

    /* perform the window function 		*/
    /* nrsh = 18 for hanning, and 15 for DFT 	*/

    for(i=0; i<Nsam; i++)
	Wn[i] =(long)sn[i] * (long)window_table[i] >> nrsh; /*(1l<<15);*/
}

