/*---------------------------------------------------------------------------*\

    FILE....: VPBDIAL.H
    TYPE....: C++ Module Header File
    AUTHOR..: David Rowe
    DATE....: 13/2/98

	This file contains the implementation of the vpb_dial API function.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VPBDIAL__
#define	__VPBDIAL__

#include <vpbapi.h>
#include <vt/tonegen.h>


//! Change the default length of @c DTMF tones.
//{{{
//! Must be called before @c vpbdial_open() to modify the prototype DTMF tone
//! definition.  This will result in all digits being of the modified length.
//}}}
void vpbdial_change_dtmf_length(int ontime_ms, int offtime_ms);

//! Initialise the tone generator and dial module.
//
//! This function should be called when the API is initialised, it loads the
//! default tone generator parameters for the standard @c DTMF tones.
void vpbdial_open();

//! Closes down vpbdial module.
void vpbdial_close();

//! Validates a dial string.
void vpbdial_validate(const std::string &dialstr);

//! Internal implementation for @c vpb_playtone_{a,}sync.
void vpbdial_playtone(int handle, const VPB_TONE &tone,
		      ToneGen::CompletionCallback callback = NULL);

#endif	// __VPBDIAL__

