
//! @file playrec.h
//! @ingroup InternalAPI
//! @brief Internal functions for audio playback and recording

/*---------------------------------------------------------------------------*\

    AUTHOR..: David Rowe
    DATE....: 10/2/98


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef	__PLAYREC__
#define	__PLAYREC__

//! @defgroup InternalPlayRec Audio playback and recording
//! @ingroup InternalAPI
//! @brief Internal interfaces for the audio playback and recording code.
//!@{
//{{{

//! Initialise the playrec module. 
//
//! @param numch The total number of channels to support.
//!
//! This module is opened once for all ports on all boards in the system.
void playrec_open(unsigned int numch);

//! Closes the playrec module.
void playrec_close();


//! Called by the @c MMQ when the @c DSP detects a digit event.
//
//! Causes a record operation on @a handle to be terminated if @a digit is
//! listed in its @c Record::term_digit field.
void playrec_new_digit_record(int handle, char digit);

//! Called by the @c MMQ when the @c DSP detects a digit event.
//
//! Causes a playback operation on @a handle to be terminated if @a digit is
//! listed in its @c Play::term_digit field.
void playrec_new_digit_play(int handle, char digit);

//! Reset the hardware play gain to the configured default value.
void play_reset_hw_gain( int handle );

//! Reset the hardware record gain to the configured default value.
void record_reset_hw_gain( int handle );

//!@} //}}}  group InternalPlayRec

#endif	// __PLAYREC__
