/*---------------------------------------------------------------------------*\

    FILE....: TRANSEVT.CPP
    TYPE....: C Module
    AUTHOR..: David Rowe
    DATE....: 26/3/98

    The functions in this module translate events from the VPB API to
	meaningfull strings.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2008 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include "vpbapi.h"
#include "digits.h"
#include "call.h"

#include <cassert>
#include <cstdio>
#include <cstring>

static const char *tonestr[] = {
	"Dial",
	"US Ringback",
	"US Busy",
	"Grunt",
	"Studio 308 Ringback",
	"Studio 308 Busy",
	"Fax",
	"Australian Busy"
};


/*---------------------------------------------------------------------------*\

	FUNCTION: vpb_translate_event
	AUTHOR..: David Rowe
	DATE....: 26/3/98

	Function to translate the current event into a string.

\*--------------------------------------------------------------------------*/

void WINAPI vpb_translate_event(VPB_EVENT *e, char s[])
//	VPB_EVENT	e;		// input event to translate
//	char		s[];	// translated string, VPB_MAX_STR long
{

	switch(e->type) {

		case VPB_RING:
			sprintf(s, "[%02d] Ring\n",e->handle);
		break;

		case VPB_RING_OFF:
			sprintf(s, "[%02d] Ring Off\n",e->handle);
		break;

		case VPB_DROP:
			sprintf(s, "[%02d] Loop Drop\n",e->handle);
		break;

		case VPB_DIGIT:
			sprintf(s, "[%02d] Digit buffer : '%s'\n",e->handle,digits_term(e->data));
		break;

		case VPB_TONEDETECT:
			if (e->data <= VPB_FAX)
				sprintf(s, "[%02d] Tone Detect: %s\n",e->handle,tonestr[e->data]);
			else
				sprintf(s, "[%02d] Tone Detect: %d\n",e->handle,e->data);
		break;

		case VPB_PLAYEND:
			sprintf(s, "[%02d] Play End\n",e->handle);
		break;

		case VPB_RECORDEND:
			sprintf(s, "[%02d] Record End\n",e->handle);
		break;

		case VPB_DIALEND:
			sprintf(s, "[%02d] Dial End\n",e->handle);
		break;

		case VPB_TIMEREXP:
			sprintf(s, "[%02d] Timer expire\n",e->handle);
		break;

		case VPB_TONE_DEBUG_END:
			sprintf(s, "[%02d] Tone detector debug end\n",e->handle);
		break;

		case VPB_VOXON:
			sprintf(s, "[%02d] Vox ON\n",e->handle);
		break;

		case VPB_VOXOFF:
			sprintf(s, "[%02d] Vox OFF\n",e->handle);
		break;

		case VPB_CALLEND:
			sprintf(s, "[%02d] Call : '%s'\n",e->handle,call_term(e->data));
		break;

              #if 0
		case VPB_PLAY_UNDERFLOW:
			sprintf(s, "[%02d] Play fifo underflow\n",e->handle);
		break;

		case VPB_RECORD_OVERFLOW:
			sprintf(s, "[%02d] Record fifo overflow\n",e->handle);
		break;
              #endif

		case VPB_DTMF:
			sprintf(s, "[%02d] DTMF digit (up): %c\n",e->handle, (char)e->data);
		break;

		case VPB_DTMF_DOWN:
			sprintf(s, "[%02d] DTMF digit (down): %c\n",e->handle,
				(char)e->data);
		break;

		case VPB_STATION_OFFHOOK:
			sprintf(s, "[%02d] Station OFF Hook\n",e->handle);
		break;

		case VPB_STATION_ONHOOK:
			sprintf(s, "[%02d] Station ON Hook\n",e->handle);
		break;

		case VPB_STATION_FLASH:
			sprintf(s, "[%02d] Station Hook FLASH\n",e->handle);
		break;

		case VPB_LOOP_OFFHOOK:
			sprintf(s, "[%02d] Loop OFF Hook\n",e->handle);
		break;

		case VPB_LOOP_ONHOOK:
			sprintf(s, "[%02d] Loop ON Hook\n",e->handle);
		break;

		case VPB_LOOP_POLARITY:
			sprintf(s, "[%02d] Loop Polarity %s\n",e->handle,
					((e->data)==0 ? "NEG":"POS"));
		break;

		case VPB_LOOP_FLASH:
			sprintf(s, "[%02d] Loop Hook FLASH\n",e->handle);
		break;

		case VPB_ISDN_BUSY:
			sprintf(s, "[%02d] ISDN busy\n",e->handle);
		break;

		case VPB_ISDN_ANS:
			sprintf(s, "[%02d] ISDN answer\n",e->handle);
		break;

		default:
			// should never get here
			sprintf(s, "undefined event code[%d]\n",e->type);
		break;
	}

	// make sure we havent made s[] to long

	assert(strlen(s) < (VPB_MAX_STR-1));
}
