%{
/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#include "vrel.h"

#include "program.h"
#include "namelist.h"

#include "declvar.h"
#include "decllist.h"

#include "inst.h"
#include "instlist.h"
#include "affectation.h"
#include "alternative.h"
#include "new.h"

#include "datalist.h"
#include "data.h"
#include "var.h"
#include "number.h"

#include "class.h"
#include "constructor.h"
#include "envconstr.h"

#include "y.tab.h"


extern "C" { char *strdup(const char *) ; }
extern void yyerror(char *s) ;

int lineNumber = 1 ;


#define YY_INPUT(buf, result, max_size) \
	{\
	int c = getc(yyin);\
	result=(c==EOF)? YY_NULL : (buf[0] = c,1);\
	}

#define RETURN  return

%}


/* Token du langage */
%%


"/*" {
	register int c;
	for( ; ; ){
		while((c=yyinput()) != '*' && c != EOF && c!= '\n');
		if(c == '*') {
			if( (c=yyinput()) == '/' )
				break;
    		}
		if(c == EOF) {
       	        	yywrap();
			break;
        	}
		if(c == '\n')
			lineNumber++ ;
	}
}	

"//" {
	while ((char)yyinput() != '\n') ;
	lineNumber++ ;
}


"var"                 { yylval.lineNo = lineNumber ; RETURN VAR ;}
"begin"               { yylval.lineNo = lineNumber ; RETURN BEGINKEY ;}
"end"                 { yylval.lineNo = lineNumber ; RETURN END ;}
"import"              { yylval.lineNo = lineNumber ; RETURN IMPORT ;}
"if"                  { yylval.lineNo = lineNumber ; RETURN IF ;}
"else"                { yylval.lineNo = lineNumber ; RETURN ELSE ;}
"while"               { yylval.lineNo = lineNumber ; RETURN WHILE ;}
"new"                 { yylval.lineNo = lineNumber ; RETURN NEW ;}
"compound"            { yylval.lineNo = lineNumber ; RETURN COMPOUND ;}
"class"               { yylval.lineNo = lineNumber ; RETURN CLASSE ;}
"extends"             { yylval.lineNo = lineNumber ; RETURN EXTENDS ;}
"constructor"         { yylval.lineNo = lineNumber ; RETURN CONSTRUCTOR ;}
"="                   { yylval.lineNo = lineNumber ; RETURN EGAL ;}
"+"                   { yylval.lineNo = lineNumber ; RETURN PLUS ;}
"-"                   { yylval.lineNo = lineNumber ; RETURN MOINS ;}
"*"                   { yylval.lineNo = lineNumber ; RETURN MULT ;}
"/"                   { yylval.lineNo = lineNumber ; RETURN DIV ;}
"mod"                 { yylval.lineNo = lineNumber ; RETURN MOD ;}
"abs"                 { yylval.lineNo = lineNumber ; RETURN ABS ;}
">"                   { yylval.lineNo = lineNumber ; RETURN SUP ;}
"<"                   { yylval.lineNo = lineNumber ; RETURN INF ;}
">="                  { yylval.lineNo = lineNumber ; RETURN SUPEGAL ;}
"<="                  { yylval.lineNo = lineNumber ; RETURN INFEGAL ;}
"=="                  { yylval.lineNo = lineNumber ; RETURN EGALEGAL ;}
"!="                  { yylval.lineNo = lineNumber ; RETURN DIFFERENT ;}
"!"                   { yylval.lineNo = lineNumber ; RETURN NOT ;}
"&&"                  { yylval.lineNo = lineNumber ; RETURN AND ;}
"||"                  { yylval.lineNo = lineNumber ; RETURN OR ;}
"("                   { yylval.lineNo = lineNumber ; RETURN PARENTOUVR ;}
")"                   { yylval.lineNo = lineNumber ; RETURN PARENTFERM ;}
"["                   { yylval.lineNo = lineNumber ; RETURN CROCHOUVR ;}
"]"                   { yylval.lineNo = lineNumber ; RETURN CROCHFERM ;}
"{"                   { yylval.lineNo = lineNumber ; RETURN ACCOUVR ;}
"}"                   { yylval.lineNo = lineNumber ; RETURN ACCFERM ;}
";"                   { yylval.lineNo = lineNumber ; RETURN PTVIRG ;}
","                   { yylval.lineNo = lineNumber ; RETURN VIRGULE ;}
"."                   { yylval.lineNo = lineNumber ; RETURN POINT ;}


"TRUE" {
	RETURN TRUE ;
}

"FALSE" {
	RETURN FALSE ;
}

[1-9][0-9]* {
	yylval.valeurint = (int)atoi(yytext);
	RETURN ENTIER ;
}

"0" {
	yylval.valeurint = (int)atoi(yytext);
	RETURN ENTIER ;
}

[+-]?[0-9]*"."[0-9]+ {
	yylval.valeurfloat = (float)atof(yytext);
	RETURN REEL ;
}

[a-zA-Z][a-zA-Z_0-9]* {
        yylval.chaine = strdup(yytext) ;
	RETURN NOM ;
}

"\""[^\n\"]*"\"" {
	int i = 0;
    	yylval.chaine = strdup(yytext) ;
	while (yylval.chaine[i+1] != '\"') {
		yylval.chaine[i] = yylval.chaine[i+1];
		i++ ;
	}
	yylval.chaine[i] = '\0';
	RETURN CHAINE ;
}

[\ \t] {}

\n {
	lineNumber++;
}

. {
	int i;
	for (i=1 ; i<10 ; i++)
		if (!feof(yyin)) {
			yytext[i] = (char)yyinput() ;
	    		if (yytext[i] == '\n')
	      		yytext[i] = '\0' ;
	  	} ;
	yytext[i] = '\0' ;
	yyerror("Caractere non reconnu") ;
}

%%


/* traitement du EOF */

int yywrap() {
	/*
	si fichier initial, return(1) sinon, return(0)	
	dcrmentation du compteur + repositionnement du pointeur
	 */

	if (comptfichier>0) {
		comptfichier-- ;
		fclose (yyin) ;
		lineNumber = tablinenumber[comptfichier] ;
		strcpy (vrelfile, tabvrelfile[comptfichier]) ;
		yyin =  tabyyin[comptfichier] ;
		return 0 ;
	}
	else {	
		yyunput(0, yytext);
		return 1;
	}
}
