// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcstream.C
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: a copy of rpcstream.C
// 
// $Id: tiorpcstream.C,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpcstream.C,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#include "tiorpcstream.h"

// Specialize this class to RPC requests by initializing an TIOrpcbuf.
// Set incomplete_request to ensure the first attempt to extract an RPC
// request will call underflow.

TIOrpcstream::TIOrpcstream() :
    _buf(this),
    _incomplete_request(true)
{
    init(&_buf);
}

TIOrpcstream::~TIOrpcstream() {}

void TIOrpcstream::attach (const TransparentIOPtr& tio) {
    verify(rdbuf()->attach(tio) != nil);
}

void TIOrpcstream::close() {
    verify(rdbuf()->close() != nil);
}

// For some of the functions above, success means starting over with a
// clean slate while failure means setting failbit as usual.

void TIOrpcstream::verify(int ok) {
    if (ok) {
	clear();
    } else {
	setstate(ios::failbit);
    }
}
