#!/usr/bin/env python
#
# vsdump: test program to dump and parse content of vsd file
#
# Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 3 or later of the GNU General Public
# License as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA
import gobject
import gtk
import vsdoc
import vsdfuncs
import tree
import hexdump

ui_info = \
'''<ui>
  <menubar name='MenuBar'>
    <menu action='FileMenu'>
      <menuitem action='Open'/>
      <separator/>
      <menuitem action='Quit'/>
    </menu>
    <menu action='HelpMenu'>
      <menuitem action='About'/>
    </menu>
  </menubar>
</ui>'''

def register_stock_icons():
    ''' This function registers our custom toolbar icons, so they  can be themed. '''
    # Add our custom icon factory to the list of defaults
    factory = gtk.IconFactory()
    factory.add_default()

class ApplicationMainWindow(gtk.Window):
   def __init__(self, parent=None):
        register_stock_icons()
        # Create the toplevel window
        gtk.Window.__init__(self)
        try:
            self.set_screen(parent.get_screen())
        except AttributeError:
            self.connect('destroy', lambda *w: gtk.main_quit())

        self.set_title("Pyneechego")
        self.set_default_size(300, 200)

        merge = gtk.UIManager()
        self.set_data("ui-manager", merge)
        merge.insert_action_group(self.__create_action_group(), 0)
        self.add_accel_group(merge.get_accel_group())

        try:
            mergeid = merge.add_ui_from_string(ui_info)
        except gobject.GError, msg:
            print "building menus failed: %s" % msg
        bar = merge.get_widget("/MenuBar")
        bar.show()

        table = gtk.Table(1, 3, False)
        self.add(table)

        table.attach(bar,
            # X direction #          # Y direction
            0, 1,                      0, 1,
            gtk.EXPAND | gtk.FILL,     0,
            0,                         0);
        
        self.notebook =gtk.Notebook()
        self.notebook.set_tab_pos(gtk.POS_BOTTOM)
        table.attach(self.notebook,
            # X direction #          # Y direction
            0, 1,                      1, 2,
            gtk.EXPAND | gtk.FILL,     gtk.EXPAND | gtk.FILL,
            0,                         0);

        # Create statusbar
        self.statusbar = gtk.Statusbar()
        table.attach(self.statusbar,
            # X direction           Y direction
            0, 1,                   2, 3,
            gtk.EXPAND | gtk.FILL,  0,
            0,                      0)
        self.show_all()

   def __create_action_group(self):
        # GtkActionEntry
        entries = (
          ( "FileMenu", None, "_File" ),               # name, stock id, label
          ( "HelpMenu", None, "_Help" ),               # name, stock id, label
          ( "Open", gtk.STOCK_OPEN,                    # name, stock id
            "_Open","<control>O",                      # label, accelerator
            "Open a file",                             # tooltip
            self.activate_open),
          ( "Quit", gtk.STOCK_QUIT,                    # name, stock id
            "_Quit", "<control>Q",                     # label, accelerator
            "Quit",                                    # tooltip
            self.activate_quit ),
          ( "About", None,                             # name, stock id
            "_About", "<control>A",                    # label, accelerator
            "About",                                   # tooltip
            self.activate_about ),
        );

        # Create the menubar and toolbar
        action_group = gtk.ActionGroup("AppWindowActions")
        action_group.add_actions(entries)
        return action_group

   def activate_about(self, action):
        dialog = gtk.AboutDialog()
        dialog.set_name("Pychego")
        dialog.set_copyright("\302\251 Copyright 2007 V.F.")
        dialog.set_website("http://www.gnome.ru/")
        ## Close dialog on user response
        dialog.connect ("response", lambda d, r: d.destroy())
        dialog.show()

   def activate_quit(self, action):
         gtk.main_quit()
         return
 
   def update_statusbar(self, buffer):
        # clear any previous message, underflow is allowed
        self.statusbar.push(0,'%s' % (buffer))

   def update_resize_grip(self, widget, event):
        mask = gtk.gdk.WINDOW_STATE_MAXIMIZED | gtk.gdk.WINDOW_STATE_FULLSCREEN
        if (event.changed_mask & mask):
            self.statusbar.set_has_resize_grip(not (event.new_window_state & mask))

   def on_row_activated(self, view, path, column, hd):
        model = view.get_model()
        iter = model.get_iter(path)
        value = model.get_value(iter,0)
        pntr = value["pointer"]
        data = pntr.data
        str_addr = ''
        str_hex = ''
        str_asc = ''
        for line in range(0, len(data), 16):
            str_addr+="%07x: "%line
            end = min(16, len(data) - line)
            for byte in range(0, 15):
                if byte < end:
                    str_hex+="%02x " % ord(data[line + byte])
                    if ord(data[line + byte]) < 32 or 126<ord(data[line + byte]):
                        str_asc +='.'
                    else:
                        str_asc += data[line + byte]
            if end > 15:			
                str_hex+="%02x" % ord(data[line + 15])
                if ord(data[line + 15]) < 32 or 126<ord(data[line + 15]):
                    str_asc += '.'
                else:
                    str_asc += data[line + 15]
                str_hex+='\n'
                str_asc+='\n'
                str_addr+='\n'
        
        buffer_addr = hd.txtdump_addr.get_buffer()
        iter_addr = buffer_addr.get_iter_at_offset(0)
        iter_addr_end = buffer_addr.get_iter_at_offset(buffer_addr.get_char_count())
        buffer_addr.delete(iter_addr, iter_addr_end)
        buffer_addr.insert_with_tags_by_name(iter_addr, str_addr,"monospace")
        buffer_hex = hd.txtdump_hex.get_buffer()
        iter_hex = buffer_hex.get_iter_at_offset(0)
        iter_hex_end = buffer_hex.get_iter_at_offset(buffer_hex.get_char_count())
        buffer_hex.delete(iter_hex, iter_hex_end)
        buffer_hex.insert_with_tags_by_name(iter_hex, str_hex,"monospace")
        buffer_asc = hd.txtdump_asc.get_buffer()
        iter_asc = buffer_asc.get_iter_at_offset(0)
        iter_asc_end = buffer_asc.get_iter_at_offset(buffer_asc.get_char_count())
        buffer_asc.delete(iter_asc, iter_asc_end)
        buffer_asc.insert_with_tags_by_name(iter_asc, str_asc,"monospace")
        
   def activate_open(self,parent=None):
        fname = self.file_open()       
        model,view,scrolled = tree.make_view()
        vsditer = vsdfuncs.vsdopen(fname,model)
        hd = hexdump.hexdump()
        if vsditer != None:
            value = model.get_value(vsditer,0)
            vsdpntr = value["pointer"]
            vsdocum = vsdfuncs.vsdparse(vsdpntr,model,hd)
            self.update_statusbar(fname+' was opened.  Version: %x'%vsdocum.version)
            pagepntr,pnum = vsdfuncs.getpagenum(vsdocum)
            print 'Num of pages: %u'%pnum
	    vsdfuncs.getcolors(vsdocum)
        
#        face = vsdoc.VsdFace(pagepntr,model,vsdocum)
#	face.set_size_request(300,200)
#        hd.vscroll1.add_with_viewport(face)
        vpaned = hd.vpaned
        view.connect("row-activated", self.on_row_activated, hd)
        hpaned = gtk.HPaned()
        hpaned.add1(scrolled)
        hpaned.add2(vpaned)
        label = gtk.Label("Test")
        self.notebook.append_page(hpaned, label)
        self.notebook.show_tabs = True
        self.notebook.show_all()
        return
        
   def file_open(self,parent=None, dirname=None, fname=None):
        dlg = gtk.FileChooserDialog('Open', parent, buttons=(gtk.STOCK_OK,gtk.RESPONSE_OK,gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL))
        dlg.set_local_only(True)
        resp = dlg.run()
        fname = dlg.get_filename()
        dlg.hide()
        if resp == gtk.RESPONSE_CANCEL:
            return None
        return fname
	
def main():
    ApplicationMainWindow()
    gtk.main()

if __name__ == '__main__':
    main()
