/*
	This program add a RUNLEVEL record in a utmp file.
	This is used when a vserver lack a private init process
	so runlevel properly report the fake runlevel.
*/
#include <utmp.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

static void usage()
{
	fprintf (stderr,"fakerunlevel version %s\n",VERSION);
	fprintf (stderr
		,"\n"
		 "fakerunlevel runlevel utmp_file\n"
		 "\n"
		 "Put a runlevel record in file utmp_file\n");
}

int main (int argc, char *argv[])
{
	if (argc != 3){
		usage();
	}else{
		int runlevel = atoi(argv[1]);
		const char *fname = argv[2];
		if (runlevel < 1 || runlevel > 5){
			usage();
		}else{
			// Make sure the file exist
			FILE *fout = fopen (fname,"a");
			if (fout == NULL){
				fprintf (stderr,"Can't open file %s (%s)\n",fname
					,strerror(errno));
			}else{
				fclose (fout);
				utmpname (fname);
				setutent();
				struct utmp ut;
				memset (&ut,0,sizeof(ut));
				ut.ut_type = RUN_LVL;
				ut.ut_pid = ('#' << 8) + runlevel+'0';
				pututline (&ut);
				endutent();
			}
		}
	}
}

