#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/stat.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 2){
		fprintf (stderr
			,"filetime version %s\n"
			 "filetime file\n"
			 "\n"
			 "Prints the age of a file\n"
			 "(how long since it was created or modified)\n"
			,VERSION);
	}else{
		struct stat st;
		if (stat(argv[1],&st)==-1){
			fprintf (stderr,"Can't stat file %s (%s)\n",argv[1]
				,strerror(errno));
		}else{
			time_t now = time(NULL);
			time_t since = now - st.st_mtime;
			int days = since / (24*60*60);
			int today = since % (24*60*60);
			int hours = today / (60*60);
			int minutes = (today % (60*60)) / 60;
			if (days > 0){
				printf ("%d days ",days);
			}
			printf ("%02d:%02d\n",hours,minutes);
			ret = 0;
		}
	}
	return ret;
}

