/*
	Litte utility to extract non config file from
	an rpm --dump command.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>


int main (int argc, char *argv[])
{
	int tblen[argc];
	for (int i=1; i<argc; i++) tblen[i] = strlen(argv[i]);
	char tmp[1000];
	while (fgets(tmp,sizeof(tmp)-1,stdin)!=NULL){
		int i;
		// Check if the file is in an excluded directory
		for (i=1; i<argc; i++){
			if (strncmp(argv[i],tmp,tblen[i])==0) break;
		}
		if (i == argc){
			// Ok no match
			int last = strlen(tmp)-1;
			if (last >= 0 && tmp[last] == '\n') tmp[last] = '\0';
			int mode=-1,type=-1;
			char *start = tmp;
			for (int i=0; i<8; i++){
				char *pt = start;
				while (*pt > ' ') pt++;
				if (*pt == ' ') *pt++ = '\0';
				if (i == 4){
					sscanf(start,"%o",&mode);
				}else if (i==7){
					type = atoi(start);
				}
				start = pt;
					
			}			
			if (S_ISREG(mode) && type == 0) printf ("%s\n",tmp);
		}
	}
	return 0;
}

