/*
	Program to substract one list from another

	subarg arg1 ... argN -- subarg1 subarg2

	The program print arg1 to argN, but skip argument member of the
	subarg set. For example

	subarg a b c d -- b d

	prints

	a c
*/
#include <stdio.h>
#include <set>
#include <string>

using namespace std;

static void usage()
{
	fprintf (stderr,"subarg set1 -- set2\n"
		"\n"
		"Prints element of set1 not in set2\n"
		"\n"
		"subarg a b c d -- b d\n"
		"prints: a c\n");
}

int main (int argc, char *argv[])
{
	bool firstlist = true;
	set<string> res;
	for (int i=1; i<argc; i++){
		const char *arg = argv[i];
		if (strcmp(arg,"--")==0){
			firstlist = false;
		}else if (firstlist){
			res.insert (arg);
		}else if (res.find(arg)!=res.end()){
			res.erase (arg);
		}
	}
	if (firstlist){
		usage();
	}else{
		for (set<string>::iterator it=res.begin(); it!=res.end(); it++){
			printf ("%s\n",it->c_str());
		}
	}
	return 0;
}

