/*
	Test the chrootsafe command.
	Pass the path of a vserver as the only argument

	chrootsafe /vservers/test
*/
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>
#include <errno.h>
#include <unistd.h>
#include "../vutil.h"

int main (int argc, char *argv[])
{
	// This test must fail
	int fd = open ("/",O_RDONLY);
	if (fd != -1){
		if (call_chrootsafe(argv[1])==-1){
			fprintf (stderr,"Ok, chrootsafe failed with one open directory errno=%s\n",strerror(errno));
		}else{
			fprintf (stderr,"Hum, chrootsafe succeed with one open directory\n");
			system ("/bin/sh");
		}
		close (fd);
	}
	// Now it should work
	if (call_chrootsafe(argv[1])!=-1){
		fprintf (stderr,"Ok, chrootsafe worked\n");
		system ("/bin/sh");
	}else{
		fprintf (stderr,"chrootsafe failed errno=%s\n",strerror(errno));
	}
	return 0;
}	

