#ifndef FLAGROWOBJ_H
#define FLAGROWOBJ_H

#include <qmainwindow.h>

#include "mapobj.h"
#include "flagobj.h"

class FlagRowObj:public QObject,public MapObj {
public:
    FlagRowObj ();
    FlagRowObj (QCanvas*);
    ~FlagRowObj ();
    virtual void init ();
    virtual void copy (FlagRowObj*);
    virtual void clone(FlagRowObj*);
    virtual void move   (double,double);
    virtual void moveBy (double,double);
    virtual void setVisibility(bool);
    virtual FlagObj* addFlag (FlagObj *fo);			// make deep copy of FlagObj
    virtual void positionBBox();
    virtual void calcBBoxSize();
	virtual QString getFlagName (const QPoint &p);	// Find flag by position
	bool isActive(const QString&);
	void toggle (const QString&,bool);
	void activate(const QString&);
	void deactivate(const QString&);
	void deactivateAll();
	void deactivateGroup(FlagObj *);
	void setEnabled (bool);
	void resetUsedCounter();
	QString saveToDir (const QString &,const QString &,bool);
	void setName (const QString&);			// prefix for exporting flags to dir
	void makeToolbar (QMainWindow*, const QString &);	// Create Toolbar buttons
	void updateToolbar();					// Update Toolbar buttons	
private:	
	FlagRowObj* parentRow;					// look for flags in this row
	FlagObj* findFlag (const QString&);
    QPtrList <FlagObj> flag; 
	QString name;
};
#endif
