#include "floatobj.h"

extern QAction* actionEditToggleFloatExport;

/////////////////////////////////////////////////////////////////
// FloatObj
/////////////////////////////////////////////////////////////////

FloatObj::FloatObj ():LinkableMapObj() 
{
//    cout << "Const FloatObj ()\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatObj::FloatObj (QCanvas* c):LinkableMapObj(c)
{
//	cout << "Const FloatObj (c)  called from MapCenterObj (c)\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatObj::FloatObj (QCanvas* c, LinkableMapObj* p):LinkableMapObj (c)
{
//    cout << "Const FloatObj (c,p)\n";
    setParObj (p);	
    depth=p->getDepth()+1;
    init();
}

FloatObj::~FloatObj ()
{
//   cout << "Destr FloatObj\n";
}

void FloatObj::init () 
{
    setChildObj(this);
	relPos=getRandPos();
	useOrientation=true;
	floatExport=true;
	zPlane=Z_ICON;
	setLinkStyle (StyleParabel);
	setHideLinkUnselected(true);
}

void FloatObj::copy (FloatObj* other)
{
	LinkableMapObj::copy (other);
	relPos=other->relPos;
	useOrientation=other->useOrientation;
	setVisibility (other->visible);
}

void FloatObj::setRelPos()
{
	if (useOrientation)
	{
		if (parObj->getOrientation()==OrientLeftOfCenter)
			relPos.setX ( parObj->x() +parObj->width() - bbox.width() -absPos.x());
		else	
			relPos.setX (absPos.x() - parObj->x() );
	}
	else
		relPos.setX (absPos.x() - parObj->x() );
	relPos.setY (absPos.y() - parObj->y() );
}

void FloatObj::setRelPos(const QPoint &p)
{
	relPos=p;
}

void FloatObj::setZ(const int &i)
{
	zPlane=i;
}

int FloatObj::z()
{
	return zPlane;
}


void FloatObj::setUseOrientation (const bool &b)
{	
	if (useOrientation!=b)
	{
		useOrientation=b;
		requestReposition();
	}	
}

void FloatObj::setFloatExport(const bool& b)
{
	floatExport=b;
}

bool FloatObj::getFloatExport()
{
	return floatExport;
}

void FloatObj::move (double x, double y)
{
	MapObj::move(x,y);
	selbox->move(x,y);
}

void FloatObj::move (QPoint p)
{
	move (p.x(), p.y());
}

void FloatObj::reposition()
{
	if (useOrientation)
	{
		if (parObj->getOrientation()==OrientLeftOfCenter)
			move (parObj->x() - relPos.x() + parObj->width() - bbox.width(), parObj->y()+relPos.y());
		else	
			move (parObj->x()+relPos.x(), parObj->y()+relPos.y());
	}		
	else
		move (parObj->x()+relPos.x(), parObj->y()+relPos.y());
	updateLink();	
}

QRect FloatObj::getTotalBBox()
{
	return bbox;
}

QRect FloatObj::getBBoxSizeWithChilds()
{
	return bboxTotal;
}

void FloatObj::select()
{
    LinkableMapObj::select();
	// Temporary draw the link while FO is selected
	if (style==StyleUndef) 
	{
		setLinkStyle(getDefLinkStyle());
		setLinkColor(parObj->getLinkColor());
	}	

	// Update FloatExport switch in context menu
	if (floatExport)
		actionEditToggleFloatExport->setEnabled (true);
	else	
		actionEditToggleFloatExport->setEnabled (true);


}

void FloatObj::unselect()
{
	LinkableMapObj::unselect();
	setLinkStyle (StyleUndef);
}

