#include <qfile.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qregexp.h>

#include "noteobj.h"

/////////////////////////////////////////////////////////////////
// NoteObj
/////////////////////////////////////////////////////////////////

NoteObj::NoteObj()
{
	clear();
}

void NoteObj::copy (NoteObj other)
{
	note=other.note;
	fonthint=other.fonthint;
	filenamehint="";
}

void NoteObj::clear()
{
	note="";
	fonthint="undef";
	filenamehint="";
}

void NoteObj::setNote (const QString &s)
{
	note=s;
}

QString NoteObj::getNote()
{
	return note;
}

void NoteObj::setFontHint (const QString &s)
{
	// only for backward compatibility (pre 1.5 )
	fonthint=s;
}

QString NoteObj::getFontHint()
{
	// only for backward compatibility (pre 1.5 )
	return fonthint;
}

void NoteObj::setFilenameHint (const QString &s)
{
	filenamehint=s;
}

QString NoteObj::getFilenameHint()
{
	return filenamehint;
}

bool NoteObj::isEmpty ()
{
	return note.isEmpty();
}

QString NoteObj::saveToDir ()
{
	// QTextEdit may generate fontnames with unquoted &, like
	// in "Lucida B&H". This is invalid in XML and thus would crash
	// the XML parser
	uint pos=0;
	uint pos2;
	bool inbracket=false;
	bool inquot=false;
	while (pos<note.length())
	{
		if (note.mid(pos,1)=="<") inbracket=true;
		if (note.mid(pos,1)==">") inbracket=false;
		if (note.mid(pos,1)=="\"" && inbracket)
		{
			if (!inquot)
				inquot=true;
			else
				inquot=false;
		}
		if (note.mid(pos,1)=="&" && inquot)
		{
			// Now we are inside  <  "  "  >
			// look for ending "
			pos2=pos+1;
			while (note.mid(pos2,1)!=";" && note.mid(pos2,1)!="\"")
				pos2++;
			if (note.mid(pos2,1)=="\"")
			{
				note.replace(pos,1,"&amp;");
				pos=pos2;
			}
		}
		pos++;
	}
	return beginElement ("htmlnote",attribut("fonthint",fonthint)) + "\n"+ note+ "\n" +endElement ("htmlnote");
}

