#
# spec file for package vym (Version 1.7.4)
#
# Copyright (c) 2005 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#

# norootforbuild
# neededforbuild  libstdc++-devel qt3-devel-packages

BuildRequires: aaa_base acl attr bash bind-utils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel gettext-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv klogd less libacl libattr libcom_err libgcc libnscd libselinux libstdc++ libxcrypt libzio m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils rcs readline sed strace sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils expat fontconfig fontconfig-devel freeglut freeglut-devel freetype2 freetype2-devel gcc gcc-c++ gdbm gettext libjpeg libjpeg-devel liblcms liblcms-devel libmng libmng-devel libpng libpng-devel libstdc++-devel libtool perl qt3 qt3-devel rpm update-desktop-files xorg-x11-Mesa xorg-x11-Mesa-devel xorg-x11-devel xorg-x11-libs

Name:         vym
License:      GPL
Group:        Productivity/Office/Other
URL:          http://www.insilmaril.de/vym/index.html
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
Autoreqprov:  on
Summary:      VYM  (View Your Mind) is a tool to generate and manipulate maps which show your thoughts.
Version:      1.7.4
Release:      1
Source0:      %name-%version.tar.gz
Source1:      %name.desktop
Source2:      x-%name.desktop
Patch0:       no-extra-header.diff
Patch1:       clipboard-vymlink-fix.diff
Patch2:       version.diff

%description
VYM  (View Your Mind) is a tool to generate and manipulate maps which
show your thoughts. Such maps can help you to improve your creativity
and effectivity. You can use them for time management, to organize
tasks, to get an overview over complex contexts, to sort your ideas
etc. Some people even think it is fun to work with such maps...



Authors:
--------
    Uwe Drechsel  <vym@insilmaril.de>

%prep
%setup -q
%patch0
%patch1
%patch2

%build
export QTDIR=/usr/lib/qt3
export PATH=$QTDIR/bin:$PATH
qmake -o Makefile vym.pro
make QTDIR=$QTDIR LIBS=" -lm -L$QTDIR/%_lib -lqt-mt -lz"

%install
mkdir -p $RPM_BUILD_ROOT%{_prefix}/bin
install -s vym $RPM_BUILD_ROOT%{_prefix}/bin
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/pixmaps
install -m 0644 icons/vym-48x48.xpm $RPM_BUILD_ROOT%{_prefix}/share/pixmaps
install -m 0644 icons/vym.png $RPM_BUILD_ROOT%{_prefix}/share/pixmaps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/scripts
install -m 0755 scripts/*.sh $RPM_BUILD_ROOT%{_datadir}/%{name}/scripts
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/lang
install -m 0644 lang/*.qm $RPM_BUILD_ROOT%{_datadir}/%{name}/lang
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/styles
install -m 0755 styles/*.* $RPM_BUILD_ROOT%{_datadir}/%{name}/styles
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/styles/wiki
install -m 0755 styles/wiki/* $RPM_BUILD_ROOT%{_datadir}/%{name}/styles/wiki
%suse_update_desktop_file -i %name Office ProjectManagement
mkdir -p $RPM_BUILD_ROOT/opt/kde3/share/mimelnk/application/
install -m 0644 %{SOURCE2} $RPM_BUILD_ROOT/opt/kde3/share/mimelnk/application/

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/share/applications/*
/usr/share/pixmaps/*
/usr/bin/vym
/usr/share/vym
/opt/kde3
%doc demos
%doc doc

%changelog -n vym
* Mon Sep 05 2005 - uwedr@suse.de
- Version 1.7.4
- Feature: Link of a branch can be hidden, if object is not selected
- Bugfix: Zoomed map no longer "jumps around" when branch is selected
  or moved.
- Bugfix: TextEditor now has grey background again, if it is empty
- Bugfix: BranchObj no longer need to connect to TextEditor, BranchObj
  is no longer a QOBJECT
* Thu Sep 01 2005 - uwedr@suse.de
- Bugfix: Some minor changes so that translations use arguments now
  instead of several calls to tr()
* Tue Aug 30 2005 - uwedr@suse.de
- Bugfix: Fixed pasting vymlinks: Pasting a branch to a target in
  another map caused vym to go in an endless loop, if the vymlink of the
  branch pointed to the new map.
- Bugfix: Invisible floatimages (which have a scrolled parent) can
  no longer can be selected
* Fri Aug 19 2005 - uwedr@suse.de
- Feature: added debian subdirectory created by Steffen Joeris
- Feature: added license to new aboutwindow
  Tue Aug 16 19:22:56 CEST 2005 - jhilmer
- Bugfix: Fixed link handling in aboutdialog.
* Tue Aug 16 2005 - uwedr@suse.de
- Feature: Added keyboard shortcut to reset zoom factor
- Bugfix: Added "..." to menu entries leading to another dialog
- Bugfix: The setting option "Delete Key" is working again
- Bugfix: A branch moved from left side to right had wrong orienation
* Tue Aug 02 2005 - uwedr@suse.de
-  Bugfix: Heading sizes now correct after moving e.g. mainbranch to
  a branch
  Mon Aug  1 22:40:29 CEST 2005 - jhilmer
- Bugfix: Problems with closing of note editor when text was modified.
- Feature: Added subscript and superscript to note editor
* Thu Jul 28 2005 - uwedr@suse.de
- Version 1.7.3
- Bugfix: Frames didn't become invisible if scrolled
- Version 1.7.2
- Bugfix: if selection changed before undo, undo worked on wrong
  branch
* Wed Jul 27 2005 - ro@suse.de
- include math.h in linkablemapobj.cpp and misc.cpp
* Thu Jul 14 2005 - uwedr@suse.de
- Version 1.7.0
* Fri Apr 15 2005 - uwedr@suse.de
- Update to 1.6.4
- Compiles on gcc4 now
* Tue Feb 08 2005 - joe@suse.de
- Change menu category
- Add .desktop files for KDE mimetypes
* Fri Jan 21 2005 - uwedr@suse.de
- Update to 1.6.0
* Fri Jan 07 2005 - adrian@suse.de
- fix build, qmake isn't anymore in $PATH by default
* Wed Sep 29 2004 - uwedr@suse.de
- Bugfix: pdf documentation was not found
* Tue Sep 28 2004 - uwedr@suse.de
- Bugfix: Import from old map generated unbreakable spaces (ugly)
- Bugfix: No warning message (even if set) before overwriting dirs (ugly)
* Sun Sep 26 2004 - uwedr@suse.de
- Update to 1.5.0
* Fri May 28 2004 - adrian@suse.de
- use "Development Design" Categories to match the menu definition (#41338)
* Tue May 25 2004 - uwedr@suse.de
- Bugfix: map is not saved with special characters in path
- Bugfix: color of branch not saved sometimes
- Bugfix: wrong path at HTML export
* Tue May 18 2004 - uwedr@suse.de
- Bugfix: invisible image when parent is scrolled
- Bugfix: Segfault pressing "enter" for floatimage
- Bugfix: Images can't be outside of exported area anymore
- Bugfix: Filenames with blanks
- Bugfix: Old maplink is shown when editing maplink
- Bugfix: always show cursor while editing heading
* Wed Apr 28 2004 - uwedr@suse.de
- Update to 1.4.0
* Tue Mar 23 2004 - uwedr@suse.de
- Bugfix: New maps were not saved
- Bugfix: Check if file is writable before saving.
* Mon Mar 22 2004 - uwedr@suse.de
- Update to 1.3.0
* Wed Feb 25 2004 - hmacht@suse.de
- building as non-root user
* Thu Sep 18 2003 - uwedr@suse.de
- Fixed #31291   (drawing error, unnecessary files)
* Tue Sep 16 2003 - uwedr@suse.de
- Update to 1.0.0
  + automatic resizing of canvas
  + Options
  + docs
  + Bugfixing
* Thu Jul 10 2003 - uwedr@suse.de
- Update to 0.7.9:
  + graphical flags
  + export as png
  + fixed rare segfault
* Thu Jun 05 2003 - uwedr@suse.de
- Initial version.
