#ifndef BRANCHOBJ_H
#define BRANCHOBJ_H

#include "floatimageobj.h"
#include "linkablemapobj.h"
#include "ornamentedobj.h"
#include "xlinkobj.h"

class BranchObjPtrList : public QPtrList<BranchObj>
{
	virtual int compareItems (QPtrCollection::Item i, QPtrCollection::Item j);
};

enum BranchModification {NewBranch, MovedBranch};
enum HideTmpMode {HideNone, HideExport};

/////////////////////////////////////////////////////////////////////////////
class BranchObj:public OrnamentedObj {
public:
    BranchObj ();
    BranchObj (QCanvas*);
    BranchObj (QCanvas*, LinkableMapObj* parent);
    ~BranchObj ();
	bool operator< ( const BranchObj & );
	bool operator== ( const BranchObj & );
    virtual void init ();
    virtual void copy (BranchObj*);
    void clear();
	virtual int getNum();				// return number of this in parent
	virtual int getNum(BranchObj*);		// return number of this in parent
	virtual int getFloatImageNum(FloatImageObj*);		
	virtual int countBranches();		
	virtual int countFloatImages();		
	virtual int countXLinks();		
    virtual void setParObjTmp (LinkableMapObj*,QPoint,int);// Only for moving Obj around
	virtual void unsetParObjTmp();			// reuse original ParObj

	virtual void unScroll();				
	virtual void toggleScroll();			// scroll or unscroll
	virtual bool isScrolled();				// returns scroll state
	virtual bool hasScrolledParent(BranchObj*);	// true, if any of the parents is scrolled
	virtual void tmpUnscroll();				// unscroll scrolled parents temporary e.g. during "find" process
	virtual void resetTmpUnscroll();		// scroll all tmp scrolled parents again e.g. when unselecting

	virtual void setVisibility(bool,int);	// set visibility
    virtual void setVisibility(bool);	    // set vis. for w
	virtual void setLinkColor();			// set the color of link
	virtual void setColorChilds(QColor);			// set the color of heading

	BranchObj* first ();				// set Iterator to first LMO
	BranchObj* next ();					// find next LMO after given one
	BranchObj* getLastIterator();		// to interrupt and resume next iteration
	void setLastIterator (BranchObj*);	// needed by next() 

	virtual void positionContents();
    virtual void move (double x,double y);
    virtual void move (QPoint);
    virtual void moveBy (double x,double y);
    virtual void moveBy (QPoint);
    virtual void positionBBox();
    virtual void calcBBoxSize();
	virtual void setDockPos();
    virtual LinkableMapObj* findMapObj(QPoint,LinkableMapObj*);	// find MapObj 
    virtual void setHeading (QString);

	virtual void setHideTmp (HideTmpMode);
	virtual bool hasHiddenExportParent (BranchObj*);

	virtual QString saveToDir (const QString&,const QString&, const QPoint&);// Save data recursivly to tempdir
	virtual void addXLink (XLinkObj*);
	virtual void removeXLinkRef (XLinkObj*);// Remove ref in list
	virtual void deleteXLink (XLinkObj*);	// remove references and delete XLinkObj 
	virtual void deleteXLinkAt (int);		// remove references and delete XLinkObj 
	virtual XLinkObj* XLinkAt (int);		// return reference of XLinkObj 
	virtual int countXLink ();
	virtual BranchObj* XLinkTargetAt (int);
	void setIncludeImagesVer(bool);
	bool getIncludeImagesVer();
	void setIncludeImagesHor(bool);
	bool getIncludeImagesHor();
	QString getIncludeImageAttr();
	virtual LinkableMapObj* addFloatImage();
	virtual LinkableMapObj* addFloatImage(FloatImageObj*);
	virtual void removeFloatImage(FloatImageObj*);
    virtual FloatImageObj* getFirstFloatImage();
    virtual FloatImageObj* getLastFloatImage();
	virtual FloatImageObj* getFloatImageNum(const uint &);
protected:	
	virtual void savePosInAngle();					// write pos in angle for resorting			
	virtual void setDefAttr (BranchModification);	// set default attributes (font, size, ...)
public:	
    virtual BranchObj* addBranch();
    virtual BranchObj* addBranch(BranchObj*);		// makes deep copy of BranchObj
    virtual BranchObj* addBranchPtr(BranchObj*);	// just adds pointer
    virtual BranchObj* insertBranch(int);
    virtual BranchObj* insertBranch(BranchObj*,int);
    virtual BranchObj* insertBranchPtr (BranchObj*,int);
    virtual void removeBranchHere(BranchObj*);  
    virtual void removeChilds();  
    virtual void removeBranch(BranchObj*);  
    virtual void removeBranchPtr (BranchObj*);  
    virtual void setLastSelectedBranch(BranchObj*);
    virtual BranchObj* getLastSelectedBranch();
    virtual BranchObj* getFirstBranch();
    virtual BranchObj* getLastBranch();
	virtual BranchObj* getBranchNum(const uint &);
    virtual bool canMoveBranchUp();
    virtual BranchObj* moveBranchUp(BranchObj*);
    virtual bool canMoveBranchDown();
    virtual BranchObj* moveBranchDown(BranchObj*);
    virtual BranchObj* moveBranchTo (BranchObj*, int);
    virtual void alignRelativeTo(const QPoint );
	virtual void reposition();

	virtual QRect getTotalBBox();			// return BBox including childs			
	virtual QRect getBBoxSizeWithChilds();	// return size of BBox including childs  
	virtual void calcBBoxSizeWithChilds();	// calc size of  BBox including childs recursivly

    virtual void select();
    virtual void unselect();
	virtual QString getSelectString();

protected:
	static BranchObj* itLast;		// iterator for first(), next()
    BranchObjPtrList branch;		// all child branches
	QPtrList<FloatImageObj> floatimage;	// child images
	QPtrList<XLinkObj> xlink;		// xlinks to other branches
public:	
	float angle;					// used in mainbranch to reorder mainbranches
protected:	
    int lastSelectedBranch;			// for going deeper into tree
	bool scrolled;					// true if all childs are scrolled and thus invisible
	bool tmpUnscrolled;				// can only be true (temporary) for a scrolled subtree
	bool includeImagesVer;			// include floatimages in bbox vertically
	bool includeImagesHor;			// include floatimages in bbox horizontally

};


#endif

