/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


extern Settings settings;

void ExportHTMLDialog::init()
{
	dir=settings.readEntry ("/vym/export/html/dir","" );
	lineEdit1->setText(dir);
	
    if ( settings.readEntry ("/vym/export/html/image","yes")=="yes")
		image=true;
	else	
		image=false;
	checkBox4->setChecked(image);
	
	if ( settings.readEntry ("/vym/export/html/imageOnly","no")=="yes")
		imageOnly=true;
	else	
		imageOnly=false;
	checkBox5_2->setChecked(imageOnly);
		
    if ( settings.readEntry ("/vym/export/html/wiki","no")=="yes")
		wikistyle=true;
	else	
		wikistyle=false;
	checkBox5->setChecked(wikistyle);
	
	if ( settings.readEntry ("/vym/export/html/useHeading","no")=="yes")
		useHeading=true;
	else	
		useHeading=false;
	checkBox4_2->setChecked(useHeading);
		
	if ( settings.readEntry ("/vym/export/html/useURLImage","yes")=="yes")
		useURLImage=true;
	else	
		useURLImage=false;
	checkBox6->setChecked(useURLImage);
	
	if ( settings.readEntry ("/vym/export/html/showOutput","no")=="yes")
		showOutput=true;
	else	
		showOutput=false;
	checkBox3->setChecked(showOutput);
		
	stylepath=settings.readEntry
		("/vym/export/html/styles","styles");
	scriptpath=settings.readEntry 
		("/vym/export/html/scripts","scripts");
	xsl=settings.readEntry 
		("/vym/export/html/xsl","vym2html.xsl");
	css=settings.readEntry 
		("/vym/export/html/css","vym.css");	
	script=settings.readEntry 
		("/vym/export/html/script","vym2html.sh");	
	
	proc = new QProcess( this );
	connect( proc, SIGNAL(readyReadStdout()),
			 this, SLOT(readOutput()) );

	dia=new ShowTextDialog ();
}

void ExportHTMLDialog::destroy()
{
	delete (proc);
	delete (dia);
}

void ExportHTMLDialog::browseDirectory()
{
   	QFileDialog fd( this, tr("VYM - Export HTML to directory"));
	fd.setMode (QFileDialog::DirectoryOnly);
	fd.setCaption(tr("VYM - Export HTML to directory"));
	fd.setModal (true);
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		dir=fd.selectedFile();
		lineEdit1->setText (dir );
	}
}

void ExportHTMLDialog::useWIKIpressed(bool b)
{
	wikistyle=b;
}

void ExportHTMLDialog::includeImage(bool b)
{
	image=b;
}

void ExportHTMLDialog::imgOnly(bool b)
{
	imageOnly=b;
}

void ExportHTMLDialog::useHeadingPressed(bool b)
{
	useHeading=b;
}

void ExportHTMLDialog::useURLImagePressed(bool b)
{
	useURLImage=b;
}

void ExportHTMLDialog::showOut(bool b)
{
	showOutput=b;
}

void ExportHTMLDialog::dirChanged()
{
	dir=lineEdit1->text();
}




void ExportHTMLDialog::doExport (const QString &mapname)
{
	// Save options to settings file 
	// (but don't save at destructor, which
	// is called for "cancel", too)
	settings.writeEntry ("/vym/export/html/dir",lineEdit1->text() );

	if (wikistyle)
		settings.writeEntry ("/vym/export/html/wiki","yes");
	else	
		settings.writeEntry ("/vym/export/html/wiki","no");

    if (image)
		settings.writeEntry ("/vym/export/html/image","yes");
    else
		settings.writeEntry ("/vym/export/html/image","no");	
	
  if (imageOnly)
		settings.writeEntry ("/vym/export/html/imageOnly","yes");
    else
		settings.writeEntry ("/vym/export/html/imageOnly","no");	
	
  if (useHeading)
		settings.writeEntry ("/vym/export/html/useHeading","yes");
    else
		settings.writeEntry ("/vym/export/html/useHeading","no");	
			
    if (showOutput)
		settings.writeEntry ("/vym/export/html/showOutput","yes");
    else
		settings.writeEntry ("/vym/export/html/showOutput","no");	
		
	settings.writeEntry
		("/vym/export/html/styles",stylepath);
	settings.writeEntry 
		("/vym/export/html/scripts",scriptpath);
	settings.writeEntry 
		("/vym/export/html/xsl",xsl);
	settings.writeEntry 
		("/vym/export/html/css",css);	
	settings.writeEntry 
		("/vym/export/html/script",script);	

	proc->addArgument (scriptpath + "/" + script );
	proc->addArgument(dir + maskPath(mapname) + ".xml");
	proc->addArgument("-sp=" + stylepath +"/" + xsl );
	proc->addArgument("-css=" + css );
	if (image) proc->addArgument("-image" );
	if (wikistyle) proc->addArgument("-wikistyle" );
	if (useHeading) proc->addArgument("-useURLHeading" );
	if (useURLImage) 
	{	
		proc->addArgument("-useURLImage" );
		QPixmap pm (flag_url_xpm);
		pm.save (dir + "/flags/url.png","PNG");
	}	

	dia->append ("vym is executing: " + proc->arguments().join(" ") );
	if ( !proc->start() ) 
	{
		// error handling
		dia->show();
		QString s;
		QStringList list = proc->arguments();
		QStringList::Iterator it = list.begin();
		while( it != list.end() ) 
		{
			s+= ( *it ) + "\n";
			++it;
		}
		QMessageBox::critical(0, tr("Critcal export error"),"Couldn't start script to export:\n"+s);
	} else 
		if (showOutput) dia->exec();
	

}


QString ExportHTMLDialog::getDir()
{
	return dir;
}


void ExportHTMLDialog::readOutput()
{
	dia->append (proc->readStdout() );
}
