#ifndef XLM_H
#define XLM_H


#include <qstring.h>
#include <qxml.h>

#include "file.h"
#include "mapcenterobj.h"
#include "mapeditor.h"


class mapBuilderHandler  : public QXmlDefaultHandler
{
public:
	mapBuilderHandler();
	~mapBuilderHandler();
	QString errorProtocol();
	bool startDocument();
	QString parseHREF(QString);
	bool startElement ( const QString&, const QString&,
                        const QString& eName, const QXmlAttributes& atts ); 
	bool   endElement ( const QString&, const QString&, const QString& ); 
	bool characters   ( const QString&);
	QString errorString();
	bool fatalError( const QXmlParseException&);
	void setMapEditor (MapEditor*);
	void setTmpDir (QString);
	void setInputFile (QString);
	void setLoadMode (const LoadMode &);
	bool readBranchAttr (const QXmlAttributes&);
	bool readOOAttr (const QXmlAttributes&);
	bool readNoteAttr (const QXmlAttributes&);
	bool readFloatImageAttr (const QXmlAttributes&);
	bool readXLinkAttr (const QXmlAttributes&);
	bool readHtmlAttr (const QXmlAttributes&);
	bool readSettingAttr (const QXmlAttributes&);

private:
	QString     errorProt;
	enum State 
	{ 
		StateInit, StateMap, StateMapSelect, 
		StateMapSetting,
		StateFloatImage,
		StateMapCenter, StateMapCenterStandardFlag,
		StateMapCenterHeading, StateMapCenterNote, 
		StateMapCenterFloatImage,
		
		StateBranch, StateBranchStandardFlag,
		StateBranchHeading, StateBranchNote, 
		StateBranchFloatImage, StateBranchXLink,
		StateHtmlNote, StateHtml 
	 };
				 

	LoadMode loadMode;
	bool isVymPart;
	State state;			 
	State laststate;
	QString htmldata;
	int branchDepth; 
	NoteObj no;
	MapCenterObj* mc;
	MapEditor* me; 
	QString tmpDir; 
	QString inputFile;
}; 
#endif
