
/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "sites.h"

@implementation Sites

+ alloc {
    self = [super alloc];
    return self;
}

- (void) dealloc {
    NSLog (@"Dealloc de la classe Sites\n");
    RELEASE (_sites);
    _sites = nil;
}

- initWithBook: (Sites*) sites {
    _sites = [[NSMutableArray alloc] initWithArray: [sites arrayOfSites]];
    if (_sites == nil) {
	_sites = [NSMutableArray new];
    }
    return self;
}

- (NSMutableArray*) arrayOfSites {
    return _sites;
}

- initWithFile: (NSString*) file {
    _sites = [[NSMutableArray alloc] initWithContentsOfFile: file];
    if (_sites == nil) {
	_sites = [NSMutableArray new];
    }
    return self;
}

- writeFile: (NSString*) file {
    [_sites writeToFile: file atomically: YES];
}

- addSite: (Bookmark*) bookmark {
    NSString* site = [[NSString alloc] initWithString: [bookmark site]];
    NSString* login = [[NSString alloc] initWithString: [bookmark login]];
    NSString* password = [[NSString alloc] initWithString: [bookmark password]];
    NSArray* thesite = [NSArray arrayWithObjects: site, login, password, nil];
    printf ("on va rajouter un objet dans le bookmark\n");
    [_sites addObject: thesite];	
    [_sites addObject: @"test"];
    printf ("il y a maintenant %d objets dans le bookmark\n", [_sites count]);
}

- (int) count {
    int ret = 0;
    if (_sites != nil) ret = [_sites count];
    return ret;
}

@end

@implementation SitesCombo

+ alloc {
    self = [super alloc];
    return self;
}

- (id) comboBox: (NSComboBox*) aComboBox objectValueForItemAtIndex: (int) index {
    NSString* ret = nil;
    NSLog (@"comboBox:objectValueForItemAtIndex:%d\n", index);
    if (_sites != nil)
    {
	ret = [[_sites objectAtIndex: index] objectAtIndex: 0];
	/*
	if (_observer != nil) {
	    [_observer setLogin:
		[[_sites objectAtIndex: index] objectAtIndex: 1]
		Password : 
		[[_sites objectAtIndex: index] objectAtIndex: 2]];
	}
	*/
    }
    
    return ret;
}

- (int) numberOfItemsInComboBox: (NSComboBox*) aComboBox {
    int ret = 0;
    NSLog (@"numberOfItemsInComboBox ...\n");
    ret = [self count];
    NSLog (@"on a %d lments dans la combobox\n", ret);
    return ret;
}

- (void) addObserver: (id) obs {
    _observer = obs;
}

- (void)controlTextDidChange: (NSNotification *) aNotification {
    NSLog (@"control le Texte a chang !!!\n");
}
- (void)controlTextDidBeginEditing:(NSNotification *)aNotification {
    NSLog (@"control test did begin editing... \n");
}
- (void)controlTextDidEndEditing:(NSNotification *)aNotification {
    NSLog (@"control test did end editing... \n");
}
- (BOOL)control:(NSControl *)control textShouldBeginEditing:(NSText *)fieldEditor {
    NSLog (@"control text should begin editing \n");
}

@end

