/*-----------------------------------------------------------------------------
 *  FILE: LibNotify.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Interface into libnotify fo wallpaper tray.
 *
 *-----------------------------------------------------------------------------
 */

#ifndef _LIBNOTIFY_GF_05092005
#define _LIBNOTIFY_GF_05092005

#include <libnotify/notify.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <sigc++/connection.h>

class Applet;
class Wallpapers;

namespace Gdk
{
	class Pixbuf;
};


//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Allows using the libnotify api for wallpaper changing notifies.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class LibNotify
{
	// public class interface //
	//
	public:
		LibNotify(Applet * _pApplet, Wallpapers * _pWallpapers);
		virtual ~LibNotify();

		void WallpaperChanged(Glib::ustring _szNewWallpaper);

		bool OnNotificationChangeAccept();
		void OnNotificationChangeReject();
		void OnNotificationChangeDelete();

	// private class data //
	//
	private:
		Applet *				m_pApplet;
		Wallpapers *			m_pWallpapers;
		sigc::connection		m_SigcConnection;
		
};// end class LibNotify

#endif	// end _LIBNOTIFY_GF_05092005
