#ifndef OUTPUT_MANAGER_H
#define OUTPUT_MANAGER_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Configurable.h"

class Event;
class SimulationObject;

/** The OutputManager class.

    This is the abstract base class from which all output manager
    implementations are derived from. The choices are:
    AggressiveOutputManager, LazyOutputManager, and
    AdaptiveOutputManager.

*/
class OutputManager : virtual public Configurable {
public:

  /**@name Public Class Methods of OutputManager. */
  //@{

  /// Destructor
  virtual ~OutputManager(){};
  
  /** Insert an event into the event set.
      
      This is a pure virtual function and has to be overridden by the
      user.

      @param event The output event to insert.
      @param object Ptr to the object who generated the event.
  */
  virtual void insert( const Event *event ) = 0;
  
  /** Rollback...
      
      This is a pure virtual function and has to be overridden by the
      user.

      @param rollbackTime Bound for how many antimessages will be sent.
      @param object A pointer the the object who experienced rollback.
  */
  virtual void rollback( SimulationObject *object, 
			 const VTime &rollbackTime ) = 0;
  
  /** Delete any unwanted (processed) elements.

      This is a pure virtual function and has to be overridden by the
      user.

      @param garbageCollectTime Time up to which to grbg-collect.
      @param object Simulation Object for which to grbg-collect 
  */
  virtual void garbageCollect(const VTime &garbageCollectTime,
                              SimulationObject *object) = 0;
  

  //@} // End of Public Class Methods of OutputManager.
  
protected:

  /**@name Protected Class Methods of OutputManager. */
  //@{
  
  /// Default Constructor
  OutputManager(){};
  
  //@} // End of Protected Class Methods of OutputManager.
};

#endif
