// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: TimeWarpSimulationManagerFactory.cpp
// 
//---------------------------------------------------------------------------

#include "DefaultTimeWarpEventSet.h"
#include "TimeWarpEventSetFactory.h"
#include "TimeWarpSimulationManager.h"
#include "TimeWarpSenderQueue.h"
#include "SimulationConfiguration.h"
#include "SchedulingData.h"
#include <clutils/ConfigurationChoice.h>
#include <clutils/StringUtilities.h>
using std::cerr;
using std::endl;

Configurable *
TimeWarpEventSetFactory::allocate( SimulationConfiguration &configuration,
				   Configurable *parent ) const {
  TimeWarpEventSet *retval = 0;
  TimeWarpSimulationManager *mySimulationManager = 
    dynamic_cast<TimeWarpSimulationManager *>(parent);

  ASSERT( mySimulationManager != 0 );

  if( configuration.eventListOrganizationIs( "DECENTRALIZED" ) ){
    if( configuration.eventListTypeIs( "DEFAULT" ) ){
      retval = new DefaultTimeWarpEventSet( mySimulationManager );
      clutils::debug << "(" << mySimulationManager->getSimulationManagerID()
		     << ") configured a DefaultTimeWarpEventSet as the event set" << endl;
    }
    else{
      mySimulationManager->shutdown( "Event list type \"" +
				     configuration.getEventListType() +
				    "\" is not a valid choice with decentralized" +
				     " event lists." );
    }
  }
  else if( configuration.eventListOrganizationIs( "CENTRALIZED" )){
    abort();
  }
  else{
    mySimulationManager->shutdown( "Unknown event list organization \"" +
				   configuration.getEventListOrganization() +
				   "\"" );
  }
  
  return retval;  
}

const TimeWarpEventSetFactory *
TimeWarpEventSetFactory::instance(){
  static const TimeWarpEventSetFactory *retval = new TimeWarpEventSetFactory();
  return retval;
}
