// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: TimeWarpSimulationStream.cpp
// 
//---------------------------------------------------------------------------

#include "TimeWarpSimulationStream.h"

#include <sstream>

using std::stringstream;

TimeWarpSimulationStream::TimeWarpSimulationStream(const string& fileName,
						   ios::openmode mode,
                                                   SimulationManager *simMgr) {
   mySimulationManager = simMgr;
   if(mode == ios::in){
      inFileQueue = new InFileQueue(fileName);
      outFileQueue = NULL;
   }
   else if((mode == ios::out) || (mode == ios::app)){
      inFileQueue = NULL;
      outFileQueue = new FileQueue(fileName);
   }
}

TimeWarpSimulationStream::~TimeWarpSimulationStream(){
   delete inFileQueue;
   delete outFileQueue;
}

void
TimeWarpSimulationStream::flush(){
  ASSERT(outFileQueue != NULL);
  
  // char *output = str();
  char *output    = NULL;
  string *line = new string(output);
  outFileQueue->storeLine(mySimulationManager->getSimulationTime(), line);
  seekp(ios::beg);
}

void
TimeWarpSimulationStream::garbageCollect(const VTime& garbageCollectTime){
   if(inFileQueue != NULL){
      inFileQueue->garbageCollect(garbageCollectTime);
   }
   if(outFileQueue != NULL){
      outFileQueue->garbageCollect(garbageCollectTime);
   }
}

void
TimeWarpSimulationStream::rollbackTo(const VTime& rollbackToTime){
   if(inFileQueue != NULL){
      inFileQueue->rollbackTo(rollbackToTime);
   }
   if(outFileQueue != NULL){
      outFileQueue->rollbackTo(rollbackToTime);
   }
}



