#include "NegativeEventMessageTest.h"
#include <cppunit/extensions/HelperMacros.h>
#include "warped/DeserializerManager.h"
#include "warped/EventId.h"
#include "warped/Event.h"

void 
NegativeEventMessageTest::setUp(){
  KernelMessageTest::setUp();

  vector<EventId> eventIds;
  eventIds.push_back( getEvent3()->getEventId() );
  testMessage = new NegativeEventMessage( KernelMessageTest::getDefaultSender(), 
					  KernelMessageTest::getDefaultReceiver(),
					  eventIds );
}

void 
NegativeEventMessageTest::tearDown(){
  delete testMessage;
  testMessage = 0;
}

void 
NegativeEventMessageTest::testConstructor(){
  KernelMessageTest::testConstructor( testMessage );
  CPPUNIT_ASSERT( testMessage->getDataType() == NegativeEventMessage::getNegativeEventMessageType() );
}

void 
NegativeEventMessageTest::testSerialization(){
  KernelMessageTest::testSerialization( testMessage, 
					NegativeEventMessage::getNegativeEventMessageType() );
}
