#ifndef OUTPUT_EVENTS_H
#define OUTPUT_EVENTS_H

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include "warped.h"
#include <vector>
#include <algorithm>
using std::vector;

class Event;
class VTime;

class OutputEvents {
public:
  vector<const Event *> *getEventsSentAtOrAfter( const VTime &searchTime );

  void insert( const Event *newEvent ){
    outputEvents.push_back( newEvent );
  }
  
  void garbageCollect( const VTime &gCollectTime );

  /**
     Remove an event from the set of OutputEvents.  Typically should be
     called if a negative event has been generated for an event in this set
     and we need to eliminate it.  Not deleted - deleted in the input set.
  */
  void remove( const Event *toRemove ){
    vector<const Event *>::iterator i = std::find( outputEvents.begin(),
						   outputEvents.end(),
						   toRemove );
    ASSERT( i != outputEvents.end() );
    outputEvents.erase( i );
  }

  void remove( const vector<const Event *> &toRemove ){
    for( vector<const Event *>::const_iterator i = toRemove.begin();
	 i < toRemove.end();
	 i++ ){
      remove( *i );
    }
  }

private:
  vector<const Event *> outputEvents;
};

#endif
