
#ifndef SEQUENTIAL_SIMULATION_STREAM_H
#define SEQUENTIAL_SIMULATION_STREAM_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <fstream>
#include <string>
#include "warped.h"
#include "SimulationStream.h"
using std::string;
using std::streambuf;
using std::ios;

class SequentialSimulationStream : public SimulationStream {
  friend class SequentialSimulationManager;
public:

  /**@name Public Class Methods of SequentialSimulationStream. */
  //@{

  /** Default constructor.

  Constructor for creating a sequential simulation file stream.

  @param fileName name of file to open
  @mode  open file for reading/writing
  @flag  output to file or console (true or false)
  */
  SequentialSimulationStream(const string& fileName, ios::openmode mode);
   
  /// Default destructor
  ~SequentialSimulationStream();
  
  /// virtual method that does the actual job of "endl".
  virtual void flush(){ fstream::flush(); }

  //@} // End of Public Class Methods of SequentialSimulationStream.

protected:

private:
  /** A constructor that takes a fileDescriptor as a parameter. This
      constructor is used by the SequentialSimulationManager to initialize
      wout and werr with suitable output and error streams.  This
      constructor is private so that only the SequentialSimulationManager
      can utilize this method.  @param fileHandle handle to the fstream to
      be used.

      @param mode the mode of the stream being set. */
   SequentialSimulationStream( streambuf *, ios::openmode mode );

  /**
     If we were opened with a filename, then we need to close the file at
     destruction.  If we were opened with a pointer to someone elses rdbuf,
     then we don't want to call "close".
  */
  bool closeflag;
};

#endif
