#ifndef TIMEWARP_SIMULATION_STREAM_H
#define TIMEWARP_SIMULATION_STREAM_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "SimulationStream.h"
#include "SimulationManager.h"
#include "FileQueue.h"
#include "InFileQueue.h"
#include <fstream>
#include <sstream>
using std::ostringstream;

class TimeWarpSimulationStream : public SimulationStream {
  friend class TimeWarpSimulationManager;
public:

   /**@name Public Class Methods of TimeWarpSimulationStream. */
   //@{

   /** Default constructor.

       Constructor for creating a TimeWarp simulation file stream.

       @param fileName name of file to open
       @mode  open file for reading/writing
       @flag  output to file or console (true or false)
   */
   TimeWarpSimulationStream(const string& fileName, ios::openmode mode,
                            SimulationManager *simMgr);
   
   /// Default destructor
   ~TimeWarpSimulationStream();

   /// this function does the job of "endl"
   void flush();

   /// call garbage collect on the file queue
   void garbageCollect(const VTime& garbageCollectTime);

   /// call rollback on the file queue
   void rollbackTo(const VTime& rollbackToTime);
   
   //@} // End of Public Class Methods of TimeWarpSimulationStream.

protected:

   /**@name Protected Class Attributes of TimeWarpSimulationStream. */
   //@{

   /// handle to my simulation manager
   SimulationManager *mySimulationManager;

   /// handle to an Output File Queue
   FileQueue *outFileQueue;

   /// handle to an input File Queue
   InFileQueue *inFileQueue;

   /// A output buffer if the file turns out to be an output file...
   ostringstream *myOutputBuffer;
   
   /// A pointer to the original file buffer for performing the actual I/O
   streambuf *originalBuffer;
   
   //@} // End of Protected Class Methods of TimeWarpSimulationStream.

private:
   /**@name Private Class Attributes of TimeWarpSimulationStream. */
   //@{
   
   /// Internal useful method used to setup buffers
   void setBuffer(ios::openmode mode);
   
   /** A constructor that takes a fileDescriptor as a parameter. This
       constructor is used by the TimeWarpSimulationManager to initialize wout
       and werr with suitable output and error streams.  This constructor is
       private so that only the TimeWarpSimulationManager can utilize this
       method.
       @param fileHandle handle to the fstream to be used.
       @param mode the mode of the stream being set. */
   TimeWarpSimulationStream (int fileHandle, ios::openmode mode);
   //@} // End of Private class methods of TimeWarpSimulationStream

   /**@name Private class attributes of TimeWarpSimulationManager. */
   //@{

   /// A flag to indicate if fileStream has to be closed by the destructor
   bool closeFlag;
   
   //@} // End of Private Class attributes of TimeWarpSimulationStream

};

#endif
